/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Map;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.wickedsource.docxstamper.DocxStamperConfiguration;
import org.wickedsource.docxstamper.api.DocxStamperException;
import org.wickedsource.docxstamper.api.commentprocessor.ICommentProcessor;
import org.wickedsource.docxstamper.api.typeresolver.ITypeResolver;
import org.wickedsource.docxstamper.api.typeresolver.TypeResolverRegistry;
import org.wickedsource.docxstamper.el.ExpressionResolver;
import org.wickedsource.docxstamper.processor.CommentProcessorRegistry;
import org.wickedsource.docxstamper.replace.PlaceholderReplacer;
import org.wickedsource.docxstamper.replace.typeresolver.DateResolver;
import org.wickedsource.docxstamper.replace.typeresolver.FallbackResolver;
import org.wickedsource.docxstamper.replace.typeresolver.image.Image;
import org.wickedsource.docxstamper.replace.typeresolver.image.ImageResolver;

public class DocxStamper<T> {
    private PlaceholderReplacer placeholderReplacer;
    private CommentProcessorRegistry commentProcessorRegistry;
    private TypeResolverRegistry typeResolverRegistry;
    private DocxStamperConfiguration config = new DocxStamperConfiguration();

    public DocxStamper() {
        this.initFields();
    }

    public DocxStamper(DocxStamperConfiguration config) {
        this.config = config;
        this.initFields();
    }

    private void initFields() {
        this.typeResolverRegistry = new TypeResolverRegistry(new FallbackResolver());
        this.typeResolverRegistry.registerTypeResolver(Image.class, new ImageResolver());
        this.typeResolverRegistry.registerTypeResolver(Date.class, new DateResolver("dd.MM.yyyy"));
        for (Map.Entry<Class<?>, ITypeResolver> entry2 : this.config.getTypeResolvers().entrySet()) {
            this.typeResolverRegistry.registerTypeResolver(entry2.getKey(), entry2.getValue());
        }
        ExpressionResolver expressionResolver = new ExpressionResolver(this.config);
        this.placeholderReplacer = new PlaceholderReplacer(this.typeResolverRegistry, this.config);
        this.config.getCommentProcessorsToUse().entrySet().forEach(entry -> {
            try {
                Class processorImpl = (Class)entry.getValue();
                Constructor constructor = processorImpl.getDeclaredConstructor(DocxStamperConfiguration.class, TypeResolverRegistry.class);
                Object processorInstance = constructor.newInstance(this.config, this.typeResolverRegistry);
                this.config.getCommentProcessors().put((Class)entry.getKey(), processorInstance);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
        this.commentProcessorRegistry = new CommentProcessorRegistry(this.placeholderReplacer, this.config);
        this.commentProcessorRegistry.setExpressionResolver(expressionResolver);
    }

    public void stamp(InputStream template, T contextRoot, OutputStream out) throws DocxStamperException {
        try {
            WordprocessingMLPackage document = WordprocessingMLPackage.load((InputStream)template);
            this.stamp(document, contextRoot, out);
        }
        catch (DocxStamperException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DocxStamperException(e);
        }
    }

    public void stamp(WordprocessingMLPackage document, T contextRoot, OutputStream out) throws DocxStamperException {
        try {
            this.processComments(document, contextRoot);
            this.replaceExpressions(document, contextRoot);
            document.save(out);
            this.commentProcessorRegistry.reset();
        }
        catch (DocxStamperException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DocxStamperException(e);
        }
    }

    public ICommentProcessor getCommentProcessorInstance(Class<?> interfaceToGet) {
        return (ICommentProcessor)this.config.getCommentProcessors().get(interfaceToGet);
    }

    private void replaceExpressions(WordprocessingMLPackage document, T contextObject) {
        this.placeholderReplacer.resolveExpressions(document, contextObject);
    }

    private void processComments(WordprocessingMLPackage document, T contextObject) {
        this.commentProcessorRegistry.runProcessors(document, contextObject);
    }
}

