/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper;

import java.util.HashMap;
import java.util.Map;
import org.wickedsource.docxstamper.DocxStamper;
import org.wickedsource.docxstamper.api.EvaluationContextConfigurer;
import org.wickedsource.docxstamper.api.typeresolver.ITypeResolver;
import org.wickedsource.docxstamper.el.NoOpEvaluationContextConfigurer;
import org.wickedsource.docxstamper.processor.displayif.DisplayIfProcessor;
import org.wickedsource.docxstamper.processor.displayif.IDisplayIfProcessor;
import org.wickedsource.docxstamper.processor.repeat.IParagraphRepeatProcessor;
import org.wickedsource.docxstamper.processor.repeat.IRepeatDocPartProcessor;
import org.wickedsource.docxstamper.processor.repeat.IRepeatProcessor;
import org.wickedsource.docxstamper.processor.repeat.ParagraphRepeatProcessor;
import org.wickedsource.docxstamper.processor.repeat.RepeatDocPartProcessor;
import org.wickedsource.docxstamper.processor.repeat.RepeatProcessor;
import org.wickedsource.docxstamper.processor.replaceExpression.IReplaceWithProcessor;
import org.wickedsource.docxstamper.processor.replaceExpression.ReplaceWithProcessor;
import org.wickedsource.docxstamper.processor.table.ITableResolver;
import org.wickedsource.docxstamper.processor.table.TableResolver;
import org.wickedsource.docxstamper.replace.typeresolver.FallbackResolver;

public class DocxStamperConfiguration {
    private String lineBreakPlaceholder;
    private EvaluationContextConfigurer evaluationContextConfigurer = new NoOpEvaluationContextConfigurer();
    private boolean failOnUnresolvedExpression = true;
    private boolean leaveEmptyOnExpressionError = false;
    private boolean replaceUnresolvedExpressions = false;
    private String unresolvedExpressionsDefaultValue = null;
    private boolean replaceNullValues = false;
    private String nullValuesDefault = null;
    private final Map<Class<?>, Class<?>> commentProcessorsToUse = new HashMap();
    private final Map<Class<?>, Object> commentProcessors = new HashMap();
    private final Map<Class<?>, ITypeResolver> typeResolvers = new HashMap();
    private ITypeResolver defaultTypeResolver = new FallbackResolver();
    private final Map<Class<?>, Object> expressionFunctions = new HashMap();

    public DocxStamperConfiguration() {
        this.commentProcessorsToUse.put(IRepeatProcessor.class, RepeatProcessor.class);
        this.commentProcessorsToUse.put(IParagraphRepeatProcessor.class, ParagraphRepeatProcessor.class);
        this.commentProcessorsToUse.put(IRepeatDocPartProcessor.class, RepeatDocPartProcessor.class);
        this.commentProcessorsToUse.put(ITableResolver.class, TableResolver.class);
        this.commentProcessorsToUse.put(IDisplayIfProcessor.class, DisplayIfProcessor.class);
        this.commentProcessorsToUse.put(IReplaceWithProcessor.class, ReplaceWithProcessor.class);
    }

    public DocxStamperConfiguration copy() {
        DocxStamperConfiguration newConfig = new DocxStamperConfiguration().setLineBreakPlaceholder(this.lineBreakPlaceholder).setEvaluationContextConfigurer(this.evaluationContextConfigurer).setFailOnUnresolvedExpression(this.failOnUnresolvedExpression).leaveEmptyOnExpressionError(this.leaveEmptyOnExpressionError).replaceUnresolvedExpressions(this.replaceUnresolvedExpressions).unresolvedExpressionsDefaultValue(this.unresolvedExpressionsDefaultValue).replaceNullValues(this.replaceNullValues).nullValuesDefault(this.nullValuesDefault).setDefaultTypeResolver(this.defaultTypeResolver);
        this.typeResolvers.forEach(newConfig::addTypeResolver);
        this.expressionFunctions.forEach(newConfig::exposeInterfaceToExpressionLanguage);
        this.commentProcessorsToUse.forEach(newConfig::addCommentProcessor);
        return newConfig;
    }

    public DocxStamperConfiguration setLineBreakPlaceholder(String lineBreakPlaceholder) {
        this.lineBreakPlaceholder = lineBreakPlaceholder;
        return this;
    }

    public DocxStamperConfiguration setEvaluationContextConfigurer(EvaluationContextConfigurer evaluationContextConfigurer) {
        this.evaluationContextConfigurer = evaluationContextConfigurer;
        return this;
    }

    public DocxStamperConfiguration setFailOnUnresolvedExpression(boolean failOnUnresolvedExpression) {
        this.failOnUnresolvedExpression = failOnUnresolvedExpression;
        return this;
    }

    public DocxStamperConfiguration addCommentProcessor(Class<?> interfaceClass, Class<?> commentProcessorImplClass) {
        this.commentProcessorsToUse.put(interfaceClass, commentProcessorImplClass);
        return this;
    }

    public <T> DocxStamperConfiguration addTypeResolver(Class<T> resolvedType, ITypeResolver resolver) {
        this.typeResolvers.put(resolvedType, resolver);
        return this;
    }

    public DocxStamperConfiguration exposeInterfaceToExpressionLanguage(Class<?> interfaceClass, Object implementation) {
        this.expressionFunctions.put(interfaceClass, implementation);
        return this;
    }

    public DocxStamperConfiguration leaveEmptyOnExpressionError(boolean leaveEmpty) {
        this.leaveEmptyOnExpressionError = leaveEmpty;
        return this;
    }

    public DocxStamperConfiguration replaceNullValues(boolean replaceNullValues) {
        this.replaceNullValues = replaceNullValues;
        return this;
    }

    public DocxStamperConfiguration nullValuesDefault(String nullValuesDefault) {
        this.nullValuesDefault = nullValuesDefault;
        return this;
    }

    public DocxStamperConfiguration replaceUnresolvedExpressions(boolean replaceUnresolvedExpressions) {
        this.replaceUnresolvedExpressions = replaceUnresolvedExpressions;
        return this;
    }

    public DocxStamperConfiguration unresolvedExpressionsDefaultValue(String unresolvedExpressionsDefaultValue) {
        this.unresolvedExpressionsDefaultValue = unresolvedExpressionsDefaultValue;
        return this;
    }

    public DocxStamper build() {
        return new DocxStamper(this);
    }

    public EvaluationContextConfigurer getEvaluationContextConfigurer() {
        return this.evaluationContextConfigurer;
    }

    public boolean isFailOnUnresolvedExpression() {
        return this.failOnUnresolvedExpression;
    }

    public Map<Class<?>, Object> getCommentProcessors() {
        return this.commentProcessors;
    }

    public Map<Class<?>, Class<?>> getCommentProcessorsToUse() {
        return this.commentProcessorsToUse;
    }

    Map<Class<?>, ITypeResolver> getTypeResolvers() {
        return this.typeResolvers;
    }

    ITypeResolver getDefaultTypeResolver() {
        return this.defaultTypeResolver;
    }

    public DocxStamperConfiguration setDefaultTypeResolver(ITypeResolver defaultTypeResolver) {
        this.defaultTypeResolver = defaultTypeResolver;
        return this;
    }

    public boolean isLeaveEmptyOnExpressionError() {
        return this.leaveEmptyOnExpressionError;
    }

    public boolean isReplaceNullValues() {
        return this.replaceNullValues;
    }

    public String getNullValuesDefault() {
        return this.nullValuesDefault;
    }

    public boolean isReplaceUnresolvedExpressions() {
        return this.replaceUnresolvedExpressions;
    }

    public String getUnresolvedExpressionsDefaultValue() {
        return this.unresolvedExpressionsDefaultValue;
    }

    public String getLineBreakPlaceholder() {
        return this.lineBreakPlaceholder;
    }

    public Map<Class<?>, Object> getExpressionFunctions() {
        return this.expressionFunctions;
    }
}

