/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.el;

import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.wickedsource.docxstamper.DocxStamperConfiguration;
import org.wickedsource.docxstamper.el.ExpressionUtil;
import org.wickedsource.docxstamper.el.StandardMethodResolver;

public class ExpressionResolver {
    private static final ExpressionUtil expressionUtil = new ExpressionUtil();
    private final DocxStamperConfiguration configuration;

    public ExpressionResolver(DocxStamperConfiguration configuration) {
        this.configuration = configuration;
    }

    public Object resolveExpression(String expressionString, Object contextRoot) {
        if ((expressionString.startsWith("${") || expressionString.startsWith("#{")) && expressionString.endsWith("}")) {
            expressionString = expressionUtil.stripExpression(expressionString);
        }
        SpelExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext(contextRoot);
        evaluationContext.addMethodResolver((MethodResolver)new StandardMethodResolver(this.configuration));
        this.configuration.getEvaluationContextConfigurer().configureEvaluationContext(evaluationContext);
        Expression expression = parser.parseExpression(expressionString);
        return expression.getValue((EvaluationContext)evaluationContext);
    }
}

