/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.el;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.TypedValue;
import org.wickedsource.docxstamper.DocxStamperConfiguration;

public class StandardMethodExecutor
implements MethodExecutor {
    private final DocxStamperConfiguration configuration;
    private final Method method;
    private final Object implementation;

    public StandardMethodExecutor(DocxStamperConfiguration configuration, Method method, Object implementation) {
        this.configuration = configuration;
        this.method = method;
        this.implementation = implementation;
    }

    public TypedValue execute(EvaluationContext context, Object target, Object ... arguments) throws AccessException {
        try {
            return new TypedValue(this.method.invoke(this.implementation, arguments));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            if (this.configuration.isFailOnUnresolvedExpression()) {
                throw new AccessException(String.format("Error calling method %s", this.method.getName()), (Exception)e);
            }
            return new TypedValue(null);
        }
    }
}

