/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.el;

import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.MethodResolver;
import org.wickedsource.docxstamper.DocxStamperConfiguration;
import org.wickedsource.docxstamper.el.StandardMethodExecutor;

public class StandardMethodResolver
implements MethodResolver {
    private final DocxStamperConfiguration configuration;

    public StandardMethodResolver(DocxStamperConfiguration configuration) {
        this.configuration = configuration;
    }

    public MethodExecutor resolve(EvaluationContext context, Object targetObject, String name, List<TypeDescriptor> argumentTypes) throws AccessException {
        Map.Entry<Method, Object> methodEntry = this.findCommentProcessorMethod(name, argumentTypes);
        if (methodEntry == null) {
            methodEntry = this.findExpressionContextMethod(name, argumentTypes);
        }
        if (methodEntry == null) {
            return null;
        }
        return new StandardMethodExecutor(this.configuration, methodEntry.getKey(), methodEntry.getValue());
    }

    private Map.Entry<Method, Object> findCommentProcessorMethod(String expectedName, List<TypeDescriptor> expectedArguments) {
        return this.findMethodInMap(this.configuration.getCommentProcessors(), expectedName, expectedArguments);
    }

    private Map.Entry<Method, Object> findExpressionContextMethod(String expectedName, List<TypeDescriptor> expectedArguments) {
        return this.findMethodInMap(this.configuration.getExpressionFunctions(), expectedName, expectedArguments);
    }

    private Map.Entry<Method, Object> findMethodInMap(Map<Class<?>, Object> methodMap, String expectedName, List<TypeDescriptor> expectedArguments) {
        for (Map.Entry<Class<?>, Object> entry : methodMap.entrySet()) {
            Class<?> iface = entry.getKey();
            for (Method actualMethod : iface.getDeclaredMethods()) {
                if (!this.methodEquals(actualMethod, expectedName, expectedArguments)) continue;
                return new AbstractMap.SimpleEntry<Method, Object>(actualMethod, entry.getValue());
            }
        }
        return null;
    }

    private boolean methodEquals(Method actualMethod, String expectedName, List<TypeDescriptor> expectedArguments) {
        if (!actualMethod.getName().equals(expectedName)) {
            return false;
        }
        if (actualMethod.getParameterTypes().length != expectedArguments.size()) {
            return false;
        }
        for (int i = 0; i < expectedArguments.size(); ++i) {
            Class expectedType = expectedArguments.get(i) != null ? expectedArguments.get(i).getType() : null;
            Class<?> actualType = actualMethod.getParameterTypes()[i];
            if (expectedType == null || actualType.isAssignableFrom(expectedType)) continue;
            return false;
        }
        return true;
    }
}

