/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.processor.displayif;

import java.util.ArrayList;
import java.util.List;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.P;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Tr;
import org.wickedsource.docxstamper.DocxStamperConfiguration;
import org.wickedsource.docxstamper.api.typeresolver.TypeResolverRegistry;
import org.wickedsource.docxstamper.processor.BaseCommentProcessor;
import org.wickedsource.docxstamper.processor.CommentProcessingException;
import org.wickedsource.docxstamper.processor.displayif.IDisplayIfProcessor;
import org.wickedsource.docxstamper.util.ObjectDeleter;

public class DisplayIfProcessor
extends BaseCommentProcessor
implements IDisplayIfProcessor {
    private List<P> paragraphsToBeRemoved = new ArrayList<P>();
    private List<Tbl> tablesToBeRemoved = new ArrayList<Tbl>();
    private List<Tr> tableRowsToBeRemoved = new ArrayList<Tr>();
    private List<Object> objectsToBeRemoved = new ArrayList<Object>();

    public DisplayIfProcessor(DocxStamperConfiguration config, TypeResolverRegistry typeResolverRegistry) {
        super(config, typeResolverRegistry);
    }

    @Override
    public void commitChanges(WordprocessingMLPackage document) {
        ObjectDeleter deleter = new ObjectDeleter();
        this.removeParagraphs(deleter);
        this.removeTables(deleter);
        this.removeTableRows(deleter);
        this.removeObjects(deleter);
    }

    @Override
    public void reset() {
        this.paragraphsToBeRemoved = new ArrayList<P>();
        this.tablesToBeRemoved = new ArrayList<Tbl>();
        this.tableRowsToBeRemoved = new ArrayList<Tr>();
        this.objectsToBeRemoved = new ArrayList<Object>();
    }

    private void removeParagraphs(ObjectDeleter deleter) {
        for (P p : this.paragraphsToBeRemoved) {
            deleter.deleteParagraph(p);
        }
    }

    private void removeObjects(ObjectDeleter deleter) {
        for (Object object : this.objectsToBeRemoved) {
            deleter.deleteObject(object);
        }
    }

    private void removeTables(ObjectDeleter deleter) {
        for (Tbl table : this.tablesToBeRemoved) {
            deleter.deleteTable(table);
        }
    }

    private void removeTableRows(ObjectDeleter deleter) {
        for (Tr row : this.tableRowsToBeRemoved) {
            deleter.deleteTableRow(row);
        }
    }

    @Override
    public void displayParagraphIf(Boolean condition) {
        if (!condition.booleanValue()) {
            this.paragraphsToBeRemoved.add(this.getParagraph());
        }
    }

    @Override
    public void displayParagraphIfPresent(Object condition) {
        this.displayParagraphIf(condition != null);
    }

    @Override
    public void displayTableIf(Boolean condition) {
        if (!condition.booleanValue()) {
            P p = this.getParagraph();
            if (p.getParent() instanceof Tc && ((Tc)p.getParent()).getParent() instanceof Tr && ((Tr)((Tc)p.getParent()).getParent()).getParent() instanceof Tbl) {
                this.tablesToBeRemoved.add((Tbl)((Tr)((Tc)p.getParent()).getParent()).getParent());
            } else {
                throw new CommentProcessingException("Paragraph is not within a table!", p);
            }
        }
    }

    @Override
    public void displayTableRowIf(Boolean condition) {
        if (!condition.booleanValue()) {
            P p = this.getParagraph();
            if (p.getParent() instanceof Tc && ((Tc)p.getParent()).getParent() instanceof Tr) {
                this.tableRowsToBeRemoved.add((Tr)((Tc)p.getParent()).getParent());
            } else {
                throw new CommentProcessingException("Paragraph is not within a table!", p);
            }
        }
    }
}

