/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.processor.repeat;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.CommentRangeEnd;
import org.docx4j.wml.CommentRangeStart;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.P;
import org.docx4j.wml.SectPr;
import org.wickedsource.docxstamper.DocxStamperConfiguration;
import org.wickedsource.docxstamper.api.typeresolver.TypeResolverRegistry;
import org.wickedsource.docxstamper.processor.BaseCommentProcessor;
import org.wickedsource.docxstamper.processor.repeat.IParagraphRepeatProcessor;
import org.wickedsource.docxstamper.util.CommentUtil;
import org.wickedsource.docxstamper.util.CommentWrapper;
import org.wickedsource.docxstamper.util.ParagraphUtil;
import org.wickedsource.docxstamper.util.SectionUtil;

public class ParagraphRepeatProcessor
extends BaseCommentProcessor
implements IParagraphRepeatProcessor {
    private Map<P, ParagraphsToRepeat> pToRepeat = new HashMap<P, ParagraphsToRepeat>();

    public ParagraphRepeatProcessor(DocxStamperConfiguration config, TypeResolverRegistry typeResolverRegistry) {
        super(config, typeResolverRegistry);
    }

    @Override
    public void repeatParagraph(List<Object> objects) {
        P paragraph = this.getParagraph();
        List<P> paragraphs = ParagraphRepeatProcessor.getParagraphsInsideComment(paragraph);
        ParagraphsToRepeat toRepeat = new ParagraphsToRepeat();
        toRepeat.commentWrapper = this.getCurrentCommentWrapper();
        toRepeat.data = objects;
        toRepeat.paragraphs = paragraphs;
        toRepeat.sectionBreakBefore = SectionUtil.getPreviousSectionBreakIfPresent(paragraph, (ContentAccessor)paragraph.getParent());
        toRepeat.firstParagraphSectionBreak = SectionUtil.getParagraphSectionBreak(paragraph);
        toRepeat.hasOddSectionBreaks = SectionUtil.isOddNumberOfSectionBreaks(new ArrayList<P>(toRepeat.paragraphs));
        if (paragraph.getPPr() != null && paragraph.getPPr().getSectPr() != null) {
            paragraph.getPPr().setSectPr(null);
        }
        this.pToRepeat.put(paragraph, toRepeat);
    }

    @Override
    public void commitChanges(WordprocessingMLPackage document) {
        this.pToRepeat.forEach((currentP, paragraphsToRepeat) -> {
            List<Object> expressionContexts = Objects.requireNonNull(paragraphsToRepeat).data;
            ArrayList<P> paragraphsToAdd = new ArrayList<P>();
            if (expressionContexts != null) {
                paragraphsToAdd.addAll(this.generateParagraphsToAdd(document, (ParagraphsToRepeat)paragraphsToRepeat, expressionContexts));
            } else if (this.configuration.isReplaceNullValues() && this.configuration.getNullValuesDefault() != null) {
                paragraphsToAdd.add(ParagraphUtil.create(this.configuration.getNullValuesDefault()));
            }
            ParagraphRepeatProcessor.restoreFirstSectionBreakIfNeeded(paragraphsToRepeat, paragraphsToAdd);
            ContentAccessor parent = (ContentAccessor)currentP.getParent();
            int index = parent.getContent().indexOf(currentP);
            if (index >= 0) {
                parent.getContent().addAll(index, paragraphsToAdd);
            }
            parent.getContent().removeAll(paragraphsToRepeat.paragraphs);
        });
    }

    private static void restoreFirstSectionBreakIfNeeded(ParagraphsToRepeat paragraphsToRepeat, List<P> paragraphsToAdd) {
        if (paragraphsToRepeat.firstParagraphSectionBreak != null) {
            P breakP = paragraphsToAdd.get(paragraphsToAdd.size() - 1);
            SectionUtil.applySectionBreakToParagraph(paragraphsToRepeat.firstParagraphSectionBreak, breakP);
        }
    }

    private List<P> generateParagraphsToAdd(WordprocessingMLPackage document, ParagraphsToRepeat paragraphsToRepeat, List<Object> expressionContexts) {
        ArrayList<P> paragraphsToAdd = new ArrayList<P>();
        Object lastExpressionContext = expressionContexts.get(expressionContexts.size() - 1);
        for (Object expressionContext : expressionContexts) {
            P lastParagraph = paragraphsToRepeat.paragraphs.get(paragraphsToRepeat.paragraphs.size() - 1);
            for (P paragraphToClone : paragraphsToRepeat.paragraphs) {
                P pClone = (P)XmlUtils.deepCopy((Object)paragraphToClone);
                if (ParagraphRepeatProcessor.shouldResetPageOrientationBeforeNextIteration(paragraphsToRepeat, lastExpressionContext, expressionContext, lastParagraph, paragraphToClone)) {
                    SectionUtil.applySectionBreakToParagraph(paragraphsToRepeat.sectionBreakBefore, pClone);
                }
                CommentUtil.deleteCommentFromElement((ContentAccessor)pClone, paragraphsToRepeat.commentWrapper.getComment().getId());
                this.placeholderReplacer.resolveExpressionsForParagraph(pClone, expressionContext, document);
                paragraphsToAdd.add(pClone);
            }
        }
        return paragraphsToAdd;
    }

    private static boolean shouldResetPageOrientationBeforeNextIteration(ParagraphsToRepeat paragraphsToRepeat, Object lastExpressionContext, Object expressionContext, P lastParagraph, P paragraphToClone) {
        return paragraphsToRepeat.sectionBreakBefore != null && paragraphsToRepeat.hasOddSectionBreaks && expressionContext != lastExpressionContext && paragraphToClone == lastParagraph;
    }

    @Override
    public void reset() {
        this.pToRepeat = new HashMap<P, ParagraphsToRepeat>();
    }

    public static List<P> getParagraphsInsideComment(P paragraph) {
        Object parent;
        BigInteger commentId = null;
        boolean foundEnd = false;
        ArrayList<P> paragraphs = new ArrayList<P>();
        paragraphs.add(paragraph);
        for (Object object : paragraph.getContent()) {
            if (object instanceof CommentRangeStart) {
                commentId = ((CommentRangeStart)object).getId();
            }
            if (!(object instanceof CommentRangeEnd) || commentId == null || !commentId.equals(((CommentRangeEnd)object).getId())) continue;
            foundEnd = true;
        }
        if (!foundEnd && commentId != null && (parent = paragraph.getParent()) instanceof ContentAccessor) {
            ContentAccessor contentAccessor = (ContentAccessor)parent;
            int index = contentAccessor.getContent().indexOf(paragraph);
            block1: for (int i = index + 1; i < contentAccessor.getContent().size() && !foundEnd; ++i) {
                Object next = contentAccessor.getContent().get(i);
                if (next instanceof CommentRangeEnd && ((CommentRangeEnd)next).getId().equals(commentId)) {
                    foundEnd = true;
                    continue;
                }
                if (next instanceof P) {
                    paragraphs.add((P)next);
                }
                if (!(next instanceof ContentAccessor)) continue;
                ContentAccessor childContent = (ContentAccessor)next;
                for (Object child : childContent.getContent()) {
                    if (!(child instanceof CommentRangeEnd) || !((CommentRangeEnd)child).getId().equals(commentId)) continue;
                    foundEnd = true;
                    continue block1;
                }
            }
        }
        return paragraphs;
    }

    private static class ParagraphsToRepeat {
        CommentWrapper commentWrapper;
        List<Object> data;
        List<P> paragraphs;
        boolean hasOddSectionBreaks;
        SectPr sectionBreakBefore;
        SectPr firstParagraphSectionBreak;

        private ParagraphsToRepeat() {
        }
    }
}

