/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.processor.repeat;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.CommentsPart;
import org.docx4j.wml.Body;
import org.docx4j.wml.Comments;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.SectPr;
import org.docx4j.wml.Tc;
import org.jvnet.jaxb2_commons.ppp.Child;
import org.springframework.util.CollectionUtils;
import org.wickedsource.docxstamper.DocxStamper;
import org.wickedsource.docxstamper.DocxStamperConfiguration;
import org.wickedsource.docxstamper.api.typeresolver.TypeResolverRegistry;
import org.wickedsource.docxstamper.processor.BaseCommentProcessor;
import org.wickedsource.docxstamper.processor.repeat.IRepeatDocPartProcessor;
import org.wickedsource.docxstamper.util.CommentUtil;
import org.wickedsource.docxstamper.util.CommentWrapper;
import org.wickedsource.docxstamper.util.DocumentUtil;
import org.wickedsource.docxstamper.util.ParagraphUtil;
import org.wickedsource.docxstamper.util.SectionUtil;

public class RepeatDocPartProcessor
extends BaseCommentProcessor
implements IRepeatDocPartProcessor {
    private final Map<CommentWrapper, List<Object>> subContexts = new HashMap<CommentWrapper, List<Object>>();
    private final Map<CommentWrapper, List<Object>> repeatElementsMap = new HashMap<CommentWrapper, List<Object>>();
    private final Map<CommentWrapper, WordprocessingMLPackage> subTemplates = new HashMap<CommentWrapper, WordprocessingMLPackage>();
    private final Map<CommentWrapper, ContentAccessor> gcpMap = new HashMap<CommentWrapper, ContentAccessor>();
    private final Map<CommentWrapper, SectPr> previousSectionBreak = new HashMap<CommentWrapper, SectPr>();
    private final Map<CommentWrapper, Boolean> oddNumberOfBreaks = new HashMap<CommentWrapper, Boolean>();
    private static final ObjectFactory objectFactory = Context.getWmlObjectFactory();

    public RepeatDocPartProcessor(DocxStamperConfiguration config, TypeResolverRegistry typeResolverRegistry) {
        super(config, typeResolverRegistry);
    }

    @Override
    public void repeatDocPart(List<Object> contexts) throws Exception {
        ContentAccessor gcp;
        CommentWrapper currentCommentWrapper;
        List<Object> repeatElements;
        if (contexts == null) {
            contexts = Collections.emptyList();
        }
        if (!(repeatElements = this.getRepeatElements(currentCommentWrapper = this.getCurrentCommentWrapper(), gcp = RepeatDocPartProcessor.findGreatestCommonParent(currentCommentWrapper.getCommentRangeEnd().getParent(), (ContentAccessor)currentCommentWrapper.getCommentRangeStart().getParent()))).isEmpty()) {
            this.subTemplates.put(currentCommentWrapper, this.extractSubTemplate(currentCommentWrapper, repeatElements));
            this.subContexts.put(currentCommentWrapper, contexts);
            this.gcpMap.put(currentCommentWrapper, gcp);
            this.repeatElementsMap.put(currentCommentWrapper, repeatElements);
        }
    }

    private WordprocessingMLPackage copyTemplate(WordprocessingMLPackage doc) throws Docx4JException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        doc.save((OutputStream)baos);
        return WordprocessingMLPackage.load((InputStream)new ByteArrayInputStream(baos.toByteArray()));
    }

    @Override
    public void commitChanges(WordprocessingMLPackage document) {
        for (CommentWrapper commentWrapper : this.subContexts.keySet()) {
            if (commentWrapper == null) {
                throw new RuntimeException("commentWrapper should not be null");
            }
            List<Object> expressionContexts = this.subContexts.get(commentWrapper);
            ContentAccessor insertParentContentAccessor = Objects.requireNonNull(this.gcpMap.get(commentWrapper));
            List parentContent = insertParentContentAccessor.getContent();
            List<Object> repeatingElements = this.repeatElementsMap.get(commentWrapper);
            int index = parentContent.indexOf(repeatingElements.get(0));
            if (expressionContexts != null && !expressionContexts.isEmpty()) {
                Object lastExpressionContext = expressionContexts.get(expressionContexts.size() - 1);
                for (Object subContext : expressionContexts) {
                    try {
                        WordprocessingMLPackage subTemplate = this.copyTemplate(this.subTemplates.get(commentWrapper));
                        DocxStamper<Object> stamper = new DocxStamper<Object>(this.configuration.copy());
                        ByteArrayOutputStream output = new ByteArrayOutputStream();
                        stamper.stamp(subTemplate, subContext, (OutputStream)output);
                        WordprocessingMLPackage subDocument = WordprocessingMLPackage.load((InputStream)new ByteArrayInputStream(output.toByteArray()));
                        try {
                            List<Object> changes = DocumentUtil.prepareDocumentForInsert(subDocument, document);
                            if (Objects.requireNonNull(this.oddNumberOfBreaks.get(commentWrapper)).booleanValue() && this.previousSectionBreak.get(commentWrapper) != null && subContext != lastExpressionContext) {
                                P lastP;
                                if (changes.get(changes.size() - 1) instanceof P) {
                                    lastP = (P)changes.get(changes.size() - 1);
                                } else {
                                    lastP = objectFactory.createP();
                                    lastP.setParent((Object)insertParentContentAccessor);
                                    changes.add(lastP);
                                }
                                SectionUtil.applySectionBreakToParagraph(this.previousSectionBreak.get(commentWrapper), lastP);
                            }
                            insertParentContentAccessor.getContent().addAll(index, changes);
                            index += changes.size();
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Unexpected error occured ! Skipping this comment", e);
                        }
                    }
                    catch (Docx4JException e) {
                        throw new RuntimeException(e);
                    }
                }
            } else if (this.configuration.isReplaceNullValues() && this.configuration.getNullValuesDefault() != null) {
                P p = ParagraphUtil.create(this.configuration.getNullValuesDefault());
                p.setParent((Object)insertParentContentAccessor);
                insertParentContentAccessor.getContent().add(index, p);
            }
            insertParentContentAccessor.getContent().removeAll((Collection)this.repeatElementsMap.get(commentWrapper));
        }
    }

    @Override
    public void reset() {
        this.subContexts.clear();
        this.subTemplates.clear();
        this.gcpMap.clear();
        this.repeatElementsMap.clear();
        this.previousSectionBreak.clear();
        this.oddNumberOfBreaks.clear();
    }

    private WordprocessingMLPackage extractSubTemplate(CommentWrapper commentWrapper, List<Object> repeatElements) throws Exception {
        WordprocessingMLPackage document = this.getDocument();
        WordprocessingMLPackage subDocument = WordprocessingMLPackage.createPackage();
        CommentsPart commentsPart = new CommentsPart();
        subDocument.getMainDocumentPart().addTargetPart((Part)commentsPart);
        List<Object> finalRepeatElements = repeatElements.stream().map(XmlUtils::deepCopy).collect(Collectors.toList());
        RepeatDocPartProcessor.removeCommentAnchorsFromFinalElements(commentWrapper, finalRepeatElements);
        subDocument.getMainDocumentPart().getContent().addAll(finalRepeatElements);
        Body fakeBody = objectFactory.createBody();
        fakeBody.getContent().addAll(repeatElements);
        DocumentUtil.walkObjectsAndImportImages((ContentAccessor)fakeBody, document, subDocument);
        Comments comments = objectFactory.createComments();
        this.extractedSubComments(commentWrapper, comments);
        commentsPart.setContents((Object)comments);
        return subDocument;
    }

    private void extractedSubComments(CommentWrapper commentWrapper, Comments comments) {
        for (CommentWrapper child : commentWrapper.getChildren()) {
            comments.getComment().add(child.getComment());
            if (CollectionUtils.isEmpty(child.getChildren())) continue;
            this.extractedSubComments(child, comments);
        }
    }

    private static void removeCommentAnchorsFromFinalElements(CommentWrapper commentWrapper, List<Object> finalRepeatElements) {
        ContentAccessor fakeBody = () -> finalRepeatElements;
        CommentUtil.deleteCommentFromElement(fakeBody, commentWrapper.getComment().getId());
    }

    private List<Object> getRepeatElements(CommentWrapper commentWrapper, ContentAccessor greatestCommonParent) {
        ArrayList<Object> repeatElements = new ArrayList<Object>();
        boolean startFound = false;
        for (Object element : greatestCommonParent.getContent()) {
            if (!startFound && RepeatDocPartProcessor.depthElementSearch(commentWrapper.getCommentRangeStart(), element)) {
                startFound = true;
            }
            if (!startFound) continue;
            repeatElements.add(element);
            if (!RepeatDocPartProcessor.depthElementSearch(commentWrapper.getCommentRangeEnd(), element)) continue;
            break;
        }
        if (!repeatElements.isEmpty()) {
            this.previousSectionBreak.put(commentWrapper, SectionUtil.getPreviousSectionBreakIfPresent(repeatElements.get(0), greatestCommonParent));
            this.oddNumberOfBreaks.put(commentWrapper, SectionUtil.isOddNumberOfSectionBreaks(repeatElements));
        }
        return repeatElements;
    }

    private static ContentAccessor findGreatestCommonParent(Object targetSearch, ContentAccessor searchFrom) {
        if (RepeatDocPartProcessor.depthElementSearch(targetSearch, searchFrom)) {
            return RepeatDocPartProcessor.findInsertableParent(searchFrom);
        }
        return RepeatDocPartProcessor.findGreatestCommonParent(targetSearch, (ContentAccessor)((Child)searchFrom).getParent());
    }

    private static ContentAccessor findInsertableParent(ContentAccessor searchFrom) {
        if (!(searchFrom instanceof Tc) && !(searchFrom instanceof Body)) {
            return RepeatDocPartProcessor.findInsertableParent((ContentAccessor)((Child)searchFrom).getParent());
        }
        return searchFrom;
    }

    private static boolean depthElementSearch(Object searchTarget, Object content) {
        if (searchTarget.equals(content = XmlUtils.unwrap((Object)content))) {
            return true;
        }
        if (content instanceof ContentAccessor) {
            for (Object object : ((ContentAccessor)content).getContent()) {
                Object unwrappedObject = XmlUtils.unwrap(object);
                if (!searchTarget.equals(unwrappedObject) && !RepeatDocPartProcessor.depthElementSearch(searchTarget, unwrappedObject)) continue;
                return true;
            }
        }
        return false;
    }
}

