/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.processor.repeat;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.Comments;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.P;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Tr;
import org.wickedsource.docxstamper.DocxStamperConfiguration;
import org.wickedsource.docxstamper.api.typeresolver.TypeResolverRegistry;
import org.wickedsource.docxstamper.processor.BaseCommentProcessor;
import org.wickedsource.docxstamper.processor.CommentProcessingException;
import org.wickedsource.docxstamper.processor.repeat.IRepeatProcessor;
import org.wickedsource.docxstamper.processor.repeat.ParagraphResolverDocumentWalker;
import org.wickedsource.docxstamper.util.CommentUtil;
import org.wickedsource.docxstamper.util.CommentWrapper;
import org.wickedsource.docxstamper.util.walk.BaseDocumentWalker;

public class RepeatProcessor
extends BaseCommentProcessor
implements IRepeatProcessor {
    private Map<Tr, List<Object>> tableRowsToRepeat = new HashMap<Tr, List<Object>>();
    private Map<Tr, CommentWrapper> tableRowsCommentsToRemove = new HashMap<Tr, CommentWrapper>();

    public RepeatProcessor(DocxStamperConfiguration config, TypeResolverRegistry typeResolverRegistry) {
        super(config, typeResolverRegistry);
    }

    @Override
    public void commitChanges(WordprocessingMLPackage document) {
        this.repeatRows(document);
    }

    @Override
    public void reset() {
        this.tableRowsToRepeat = new HashMap<Tr, List<Object>>();
        this.tableRowsCommentsToRemove = new HashMap<Tr, CommentWrapper>();
    }

    private void repeatRows(final WordprocessingMLPackage document) {
        for (Tr row : this.tableRowsToRepeat.keySet()) {
            List<Object> expressionContexts = this.tableRowsToRepeat.get(row);
            Tbl table = (Tbl)XmlUtils.unwrap((Object)row.getParent());
            int index = table.getContent().indexOf(row);
            if (expressionContexts != null) {
                for (final Object expressionContext : expressionContexts) {
                    Tr rowClone = (Tr)XmlUtils.deepCopy((Object)row);
                    CommentWrapper commentWrapper = Objects.requireNonNull(this.tableRowsCommentsToRemove.get(row));
                    Comments.Comment comment = Objects.requireNonNull(commentWrapper.getComment());
                    BigInteger commentId = comment.getId();
                    CommentUtil.deleteCommentFromElement((ContentAccessor)rowClone, commentId);
                    BaseDocumentWalker walker = new BaseDocumentWalker((ContentAccessor)rowClone){

                        @Override
                        protected void onParagraph(P paragraph) {
                            RepeatProcessor.this.placeholderReplacer.resolveExpressionsForParagraph(paragraph, expressionContext, document);
                        }
                    };
                    walker.walk();
                    table.getContent().add(++index, rowClone);
                }
            } else if (this.configuration.isReplaceNullValues() && this.configuration.getNullValuesDefault() != null) {
                Tr rowClone = (Tr)XmlUtils.deepCopy((Object)row);
                Object nullExpressionContext = new Object();
                ParagraphResolverDocumentWalker walker = new ParagraphResolverDocumentWalker(rowClone, nullExpressionContext, document, this.placeholderReplacer);
                walker.walk();
                ((Tbl)row.getParent()).getContent().add(rowClone);
            }
            table.getContent().remove(row);
        }
    }

    @Override
    public void repeatTableRow(List<Object> objects) {
        P pCoords = this.getParagraph();
        if (!(pCoords.getParent() instanceof Tc) || !(((Tc)pCoords.getParent()).getParent() instanceof Tr)) {
            throw new CommentProcessingException("Paragraph is not within a table!", pCoords);
        }
        Tr tableRow = (Tr)((Tc)pCoords.getParent()).getParent();
        this.tableRowsToRepeat.put(tableRow, objects);
        this.tableRowsCommentsToRemove.put(tableRow, this.getCurrentCommentWrapper());
    }
}

