/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.processor.table;

import jakarta.xml.bind.JAXBElement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.P;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Tr;
import org.wickedsource.docxstamper.DocxStamperConfiguration;
import org.wickedsource.docxstamper.api.typeresolver.TypeResolverRegistry;
import org.wickedsource.docxstamper.processor.BaseCommentProcessor;
import org.wickedsource.docxstamper.processor.CommentProcessingException;
import org.wickedsource.docxstamper.processor.table.ITableResolver;
import org.wickedsource.docxstamper.processor.table.StampTable;
import org.wickedsource.docxstamper.util.ParagraphUtil;

public class TableResolver
extends BaseCommentProcessor
implements ITableResolver {
    private final Map<Tbl, StampTable> cols = new HashMap<Tbl, StampTable>();

    public TableResolver(DocxStamperConfiguration config, TypeResolverRegistry typeResolverRegistry) {
        super(config, typeResolverRegistry);
    }

    @Override
    public void resolveTable(StampTable givenTable) {
        P p = this.getParagraph();
        if (p.getParent() instanceof Tc && ((Tc)p.getParent()).getParent() instanceof Tr) {
            Tbl table = (Tbl)((Tr)((Tc)p.getParent()).getParent()).getParent();
            this.cols.put(table, givenTable);
        }
        throw new CommentProcessingException("Paragraph is not within a table!", p);
    }

    @Override
    public void commitChanges(WordprocessingMLPackage document) {
        for (Map.Entry<Tbl, StampTable> entry : this.cols.entrySet()) {
            Tbl wordTable = entry.getKey();
            StampTable stampedTable = entry.getValue();
            if (stampedTable != null) {
                this.replaceTableInplace(wordTable, stampedTable);
                continue;
            }
            if (this.configuration.isReplaceNullValues() && this.configuration.getNullValuesDefault() != null) {
                this.replaceTableWithNullDefault(wordTable);
                continue;
            }
            TableResolver.removeTableFromDocument(wordTable);
        }
    }

    private static void removeTableFromDocument(Tbl wordTable) {
        ((ContentAccessor)wordTable.getParent()).getContent().remove(wordTable);
    }

    private void replaceTableWithNullDefault(Tbl wordTable) {
        ContentAccessor accessor = (ContentAccessor)wordTable.getParent();
        int tablePosition = accessor.getContent().indexOf(wordTable);
        if (tablePosition >= 0) {
            accessor.getContent().set(tablePosition, ParagraphUtil.create(this.configuration.getNullValuesDefault()));
        }
    }

    private void replaceTableInplace(Tbl wordTable, StampTable stampedTable) {
        List<String> stampedHeaders = stampedTable.headers();
        List<List<String>> stampedRecords = stampedTable.records();
        List rows = wordTable.getContent();
        Tr headerRow = (Tr)rows.get(0);
        Tr firstDataRow = (Tr)rows.get(1);
        this.growAndFillRow(headerRow, stampedHeaders);
        if (!stampedRecords.isEmpty()) {
            this.growAndFillRow(firstDataRow, stampedRecords.get(0));
            for (List<String> rowContent : stampedRecords.subList(1, stampedRecords.size())) {
                rows.add(this.copyRowFromTemplate(firstDataRow, rowContent));
            }
        } else {
            rows.remove(firstDataRow);
        }
    }

    private Tr copyRowFromTemplate(Tr firstDataRow, List<String> rowContent) {
        Tr newXmlRow = (Tr)XmlUtils.deepCopy((Object)firstDataRow);
        List xmlRow = newXmlRow.getContent();
        for (int i = 0; i < rowContent.size(); ++i) {
            String cellContent = rowContent.get(i);
            Tc xmlCell = (Tc)((JAXBElement)xmlRow.get(i)).getValue();
            this.setCellText(xmlCell, cellContent);
        }
        return newXmlRow;
    }

    private void growAndFillRow(Tr row, List<String> values) {
        List cellRowContent = row.getContent();
        JAXBElement cell0 = (JAXBElement)cellRowContent.get(0);
        Tc cell0tc = (Tc)cell0.getValue();
        this.setCellText(cell0tc, values.isEmpty() ? "" : values.get(0));
        if (values.size() > 1) {
            for (String cellContent : values.subList(1, values.size())) {
                JAXBElement xmlCell = (JAXBElement)XmlUtils.deepCopy((Object)cell0);
                this.setCellText((Tc)xmlCell.getValue(), cellContent);
                cellRowContent.add(xmlCell);
            }
        }
    }

    private void setCellText(Tc tableCell, String content) {
        tableCell.getContent().clear();
        tableCell.getContent().add(ParagraphUtil.create(content));
    }

    @Override
    public void reset() {
        this.cols.clear();
    }
}

