/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.replace;

import java.util.List;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.Br;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelParseException;
import org.wickedsource.docxstamper.DocxStamperConfiguration;
import org.wickedsource.docxstamper.api.UnresolvedExpressionException;
import org.wickedsource.docxstamper.api.typeresolver.ITypeResolver;
import org.wickedsource.docxstamper.api.typeresolver.TypeResolverRegistry;
import org.wickedsource.docxstamper.el.ExpressionResolver;
import org.wickedsource.docxstamper.el.ExpressionUtil;
import org.wickedsource.docxstamper.util.ParagraphWrapper;
import org.wickedsource.docxstamper.util.RunUtil;
import org.wickedsource.docxstamper.util.walk.BaseCoordinatesWalker;

public class PlaceholderReplacer {
    private final Logger logger = LoggerFactory.getLogger(PlaceholderReplacer.class);
    private final ExpressionUtil expressionUtil = new ExpressionUtil();
    private final DocxStamperConfiguration configuration;
    private final ExpressionResolver expressionResolver;
    private final TypeResolverRegistry typeResolverRegistry;

    public PlaceholderReplacer(TypeResolverRegistry typeResolverRegistry, DocxStamperConfiguration configuration) {
        this.typeResolverRegistry = typeResolverRegistry;
        this.configuration = configuration;
        this.expressionResolver = new ExpressionResolver(configuration);
    }

    public void resolveExpressions(final WordprocessingMLPackage document, final Object expressionContext) {
        BaseCoordinatesWalker walker = new BaseCoordinatesWalker(document){

            @Override
            protected void onParagraph(P paragraph) {
                PlaceholderReplacer.this.resolveExpressionsForParagraph(paragraph, expressionContext, document);
            }
        };
        walker.walk();
    }

    public void resolveExpressionsForParagraph(P p, Object expressionContext, WordprocessingMLPackage document) {
        ParagraphWrapper paragraphWrapper = new ParagraphWrapper(p);
        List<String> placeholders = this.expressionUtil.findVariableExpressions(paragraphWrapper.getText());
        for (String placeholder : placeholders) {
            try {
                Object replacementObject;
                ITypeResolver resolver;
                Object replacement = this.expressionResolver.resolveExpression(placeholder, expressionContext);
                if (replacement != null) {
                    resolver = this.typeResolverRegistry.getResolverForType(replacement.getClass());
                    replacementObject = resolver.resolve(document, replacement);
                    this.replace(paragraphWrapper, placeholder, replacementObject);
                    this.logger.debug(String.format("Replaced expression '%s' with value provided by TypeResolver %s", placeholder, resolver.getClass()));
                    continue;
                }
                if (!this.configuration.isReplaceNullValues()) continue;
                resolver = this.typeResolverRegistry.getDefaultResolver();
                replacementObject = resolver.resolve(document, this.configuration.getNullValuesDefault());
                this.replace(paragraphWrapper, placeholder, replacementObject);
                this.logger.debug(String.format("Replaced expression '%s' with value provided by TypeResolver %s", placeholder, resolver.getClass()));
            }
            catch (SpelEvaluationException | SpelParseException e) {
                if (this.configuration.isFailOnUnresolvedExpression()) {
                    throw new UnresolvedExpressionException(String.format("Expression %s could not be resolved against context root of type %s. Reason: %s. Set log level to TRACE to view Stacktrace.", placeholder, expressionContext.getClass(), e.getMessage()), e);
                }
                this.logger.warn(String.format("Expression %s could not be resolved against context root of type %s. Reason: %s. Set log level to TRACE to view Stacktrace.", placeholder, expressionContext.getClass(), e.getMessage()));
                this.logger.trace("Reason for skipping expression:", e);
                if (this.configuration.isLeaveEmptyOnExpressionError()) {
                    this.replace(paragraphWrapper, placeholder, null);
                    continue;
                }
                if (!this.configuration.isReplaceUnresolvedExpressions()) continue;
                this.replace(paragraphWrapper, placeholder, this.configuration.getUnresolvedExpressionsDefaultValue());
            }
        }
        if (this.configuration.getLineBreakPlaceholder() != null) {
            this.replaceLineBreaks(paragraphWrapper);
        }
    }

    private void replaceLineBreaks(ParagraphWrapper paragraphWrapper) {
        Br lineBreak = Context.getWmlObjectFactory().createBr();
        R run = RunUtil.create(lineBreak);
        while (paragraphWrapper.getText().contains(this.configuration.getLineBreakPlaceholder())) {
            this.replace(paragraphWrapper, this.configuration.getLineBreakPlaceholder(), run);
        }
    }

    public void replace(ParagraphWrapper p, String placeholder, Object replacementObject) {
        if (replacementObject == null) {
            replacementObject = RunUtil.create("");
        }
        if (replacementObject instanceof String) {
            replacementObject = RunUtil.create((String)replacementObject, p.getParagraph());
        }
        if (replacementObject instanceof R) {
            RunUtil.applyParagraphStyle(p.getParagraph(), (R)replacementObject);
        }
        p.replace(placeholder, replacementObject);
    }
}

