/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.util;

import jakarta.xml.bind.JAXBElement;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import org.docx4j.dml.Graphic;
import org.docx4j.dml.picture.Pic;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.R;
import org.wickedsource.docxstamper.api.DocxStamperException;

public class DocxImageExtractor {
    private final WordprocessingMLPackage wordprocessingMLPackage;

    public DocxImageExtractor(WordprocessingMLPackage wordprocessingMLPackage) {
        this.wordprocessingMLPackage = wordprocessingMLPackage;
    }

    private static Graphic getInlineGraphic(Drawing drawing) {
        if (drawing.getAnchorOrInline().isEmpty()) {
            throw new DocxStamperException("Anchor or Inline is empty !");
        }
        Object anchorOrInline = drawing.getAnchorOrInline().get(0);
        if (anchorOrInline instanceof Inline) {
            Inline inline = (Inline)anchorOrInline;
            return inline.getGraphic();
        }
        throw new DocxStamperException("Don't know how to process anchor !");
    }

    private static byte[] streamToByteArray(long size, InputStream is) throws IOException {
        if (size > Integer.MAX_VALUE) {
            throw new DocxStamperException("Image size exceeds maximum allowed (2GB)");
        }
        int intSize = (int)size;
        byte[] data = new byte[intSize];
        int numRead = is.read(data);
        return Arrays.copyOfRange(data, 0, numRead);
    }

    private static Pic getPic(R run) {
        JAXBElement runElement;
        Object runContent;
        Iterator iterator = run.getContent().iterator();
        if (iterator.hasNext() && (runContent = iterator.next()) instanceof JAXBElement && (runElement = (JAXBElement)runContent).getValue() instanceof Drawing) {
            Drawing drawing = (Drawing)runElement.getValue();
            Graphic graphic = DocxImageExtractor.getInlineGraphic(drawing);
            return graphic.getGraphicData().getPic();
        }
        throw new DocxStamperException("Run drawing not found !");
    }

    private InputStream getImageStream(String imageRelPartName) throws Docx4JException {
        return this.wordprocessingMLPackage.getSourcePartStore().loadPart(imageRelPartName);
    }

    private long getImageSize(String imageRelPartName) throws Docx4JException {
        return this.wordprocessingMLPackage.getSourcePartStore().getPartSize(imageRelPartName);
    }

    private String getImageRelPartName(String imageRelId) {
        return this.wordprocessingMLPackage.getMainDocumentPart().getRelationshipsPart().getPart(imageRelId).getPartName().getName().substring(1);
    }

    byte[] getRunDrawingData(R run) throws Docx4JException, IOException {
        String imageRelId = DocxImageExtractor.getPic(run).getBlipFill().getBlip().getEmbed();
        String imageRelPartName = this.getImageRelPartName(imageRelId);
        long size = this.getImageSize(imageRelPartName);
        InputStream stream = this.getImageStream(imageRelPartName);
        return DocxImageExtractor.streamToByteArray(size, stream);
    }

    public String getRunDrawingFilename(R run) {
        return DocxImageExtractor.getPic(run).getNvPicPr().getCNvPr().getName();
    }

    public String getRunDrawingAltText(R run) {
        return DocxImageExtractor.getPic(run).getNvPicPr().getCNvPr().getDescr();
    }

    public Integer getRunDrawingMaxWidth(R run) {
        return (int)DocxImageExtractor.getPic(run).getSpPr().getXfrm().getExt().getCx();
    }
}

