/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.util;

import java.util.List;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.SectPr;

public class SectionUtil {
    private static final ObjectFactory factory = Context.getWmlObjectFactory();

    public static SectPr getPreviousSectionBreakIfPresent(Object firstObject, ContentAccessor parent) {
        int pIndex = parent.getContent().indexOf(firstObject);
        for (int i = pIndex - 1; i >= 0; ++i) {
            Object prevObj = parent.getContent().get(i);
            if (!(prevObj instanceof P)) continue;
            P prevParagraph = (P)prevObj;
            if (prevParagraph.getPPr() == null || prevParagraph.getPPr().getSectPr() == null) break;
            return prevParagraph.getPPr().getSectPr();
        }
        System.out.println("No previous section break found from : " + parent + ", first object index=" + pIndex);
        return null;
    }

    public static SectPr getParagraphSectionBreak(P p) {
        if (p.getPPr() != null && p.getPPr().getSectPr() != null) {
            return p.getPPr().getSectPr();
        }
        return null;
    }

    public static boolean isOddNumberOfSectionBreaks(List<Object> objects) {
        int count = 0;
        for (Object obj : objects) {
            P p;
            if (!(obj instanceof P) || (p = (P)obj).getPPr() == null || p.getPPr().getSectPr() == null) continue;
            ++count;
        }
        return count & true;
    }

    public static void applySectionBreakToParagraph(SectPr sectPr, P paragraph) {
        PPr currentPPr = paragraph.getPPr();
        PPr nextPPr = currentPPr != null ? currentPPr : factory.createPPr();
        paragraph.setPPr(nextPPr);
        nextPPr.setSectPr((SectPr)XmlUtils.deepCopy((Object)sectPr));
    }
}

