/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.el;

import java.util.Map;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.wickedsource.docxstamper.api.EvaluationContextConfigurer;
import org.wickedsource.docxstamper.el.ExpressionUtil;
import org.wickedsource.docxstamper.el.StandardMethodResolver;

public class ExpressionResolver {
    private final boolean failOnUnresolvedExpression;
    private final Map<Class<?>, Object> commentProcessors;
    private final Map<Class<?>, Object> expressionFunctions;
    private final EvaluationContextConfigurer evaluationContextConfigurer;

    public ExpressionResolver(boolean failOnUnresolvedExpression1, Map<Class<?>, Object> commentProcessors1, Map<Class<?>, Object> expressionFunctions1, EvaluationContextConfigurer evaluationContextConfigurer1) {
        this.failOnUnresolvedExpression = failOnUnresolvedExpression1;
        this.commentProcessors = commentProcessors1;
        this.expressionFunctions = expressionFunctions1;
        this.evaluationContextConfigurer = evaluationContextConfigurer1;
    }

    public Object resolveExpression(String expressionString, Object contextRoot) {
        if ((expressionString.startsWith("${") || expressionString.startsWith("#{")) && expressionString.endsWith("}")) {
            expressionString = ExpressionUtil.stripExpression(expressionString);
        }
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext(contextRoot);
        StandardMethodResolver methodResolver = new StandardMethodResolver(this.failOnUnresolvedExpression, this.commentProcessors, this.expressionFunctions);
        evaluationContext.addMethodResolver((MethodResolver)methodResolver);
        this.evaluationContextConfigurer.configureEvaluationContext(evaluationContext);
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression expression = parser.parseExpression(expressionString);
        return expression.getValue((EvaluationContext)evaluationContext);
    }
}

