/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.el;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ExpressionUtil {
    public static List<String> findVariableExpressions(String text) {
        return ExpressionUtil.findExpressions(text, "\\$\\{.*?\\}");
    }

    private static List<String> findExpressions(String text, String expressionPattern) {
        if (text == null) {
            return Collections.emptyList();
        }
        if (text.equals("")) {
            return Collections.emptyList();
        }
        Pattern pattern = Pattern.compile(expressionPattern);
        Matcher matcher = pattern.matcher(text);
        int index = 0;
        ArrayList<String> matches = new ArrayList<String>();
        while (matcher.find(index)) {
            String match = matcher.group();
            matches.add(match);
            index = matcher.end();
        }
        return matches;
    }

    public static List<String> findProcessorExpressions(String text) {
        return ExpressionUtil.findExpressions(text, "\\#\\{.*?\\}");
    }

    public static String stripExpression(String expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Cannot strip NULL expression!");
        }
        expression = expression.replaceAll("^\\$\\{", "").replaceAll("}$", "");
        expression = expression.replaceAll("^#\\{", "").replaceAll("}$", "");
        return expression;
    }

    private ExpressionUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

