/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.replace;

import java.util.List;
import java.util.Optional;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.Br;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelParseException;
import org.wickedsource.docxstamper.api.UnresolvedExpressionException;
import org.wickedsource.docxstamper.api.typeresolver.ITypeResolver;
import org.wickedsource.docxstamper.api.typeresolver.TypeResolverRegistry;
import org.wickedsource.docxstamper.el.ExpressionResolver;
import org.wickedsource.docxstamper.el.ExpressionUtil;
import org.wickedsource.docxstamper.util.ParagraphWrapper;
import org.wickedsource.docxstamper.util.RunUtil;
import org.wickedsource.docxstamper.util.walk.BaseCoordinatesWalker;

public class PlaceholderReplacer {
    private final Logger logger = LoggerFactory.getLogger(PlaceholderReplacer.class);
    private final ExpressionResolver expressionResolver;
    private final TypeResolverRegistry typeResolverRegistry;
    private final boolean replaceNullValues;
    private final String nullValuesDefault;
    private final boolean failOnUnresolvedExpression;
    private final boolean leaveEmptyOnExpressionError;
    private final boolean replaceUnresolvedExpressions;
    private final String unresolvedExpressionsDefaultValue;
    private final String lineBreakPlaceholder;

    public PlaceholderReplacer(TypeResolverRegistry typeResolverRegistry, ExpressionResolver resolver, boolean replaceNullValues, String nullValuesDefault, boolean failOnUnresolvedExpression1, boolean replaceUnresolvedExpressions1, String unresolvedExpressionsDefaultValue1, boolean leaveEmptyOnExpressionError1, String lineBreakPlaceholder1) {
        this.typeResolverRegistry = typeResolverRegistry;
        this.expressionResolver = resolver;
        this.replaceNullValues = replaceNullValues;
        this.nullValuesDefault = nullValuesDefault;
        this.failOnUnresolvedExpression = failOnUnresolvedExpression1;
        this.replaceUnresolvedExpressions = replaceUnresolvedExpressions1;
        this.unresolvedExpressionsDefaultValue = unresolvedExpressionsDefaultValue1;
        this.leaveEmptyOnExpressionError = leaveEmptyOnExpressionError1;
        this.lineBreakPlaceholder = lineBreakPlaceholder1;
    }

    public void resolveExpressions(final WordprocessingMLPackage document, final Object expressionContext) {
        BaseCoordinatesWalker walker = new BaseCoordinatesWalker(document){

            @Override
            protected void onParagraph(P paragraph) {
                PlaceholderReplacer.this.resolveExpressionsForParagraph(paragraph, expressionContext, document);
            }
        };
        walker.walk();
    }

    public void resolveExpressionsForParagraph(P p, Object expressionContext, WordprocessingMLPackage document) {
        ParagraphWrapper paragraphWrapper = new ParagraphWrapper(p);
        List<String> placeholders = ExpressionUtil.findVariableExpressions(paragraphWrapper.getText());
        for (String placeholder : placeholders) {
            try {
                R replacementObject;
                ITypeResolver<Object> resolver;
                Object replacement = this.expressionResolver.resolveExpression(placeholder, expressionContext);
                if (replacement != null) {
                    resolver = this.typeResolverRegistry.getResolverForType(replacement.getClass());
                    replacementObject = resolver.resolve(document, replacement);
                    this.replace(paragraphWrapper, placeholder, replacementObject);
                    this.logger.debug(String.format("Replaced expression '%s' with value provided by TypeResolver %s", placeholder, resolver.getClass()));
                    continue;
                }
                if (!this.replaceNullValues) continue;
                resolver = this.typeResolverRegistry.getDefaultResolver();
                replacementObject = resolver.resolve(document, this.nullValuesDefault);
                this.replace(paragraphWrapper, placeholder, replacementObject);
                this.logger.debug(String.format("Replaced expression '%s' with value provided by TypeResolver %s", placeholder, resolver.getClass()));
            }
            catch (SpelEvaluationException | SpelParseException e) {
                if (this.isFailOnUnresolvedExpression()) {
                    throw new UnresolvedExpressionException(String.format("Expression %s could not be resolved against context root of type %s. Reason: %s. Set log level to TRACE to view Stacktrace.", placeholder, expressionContext.getClass(), e.getMessage()), e);
                }
                this.logger.warn(String.format("Expression %s could not be resolved against context root of type %s. Reason: %s. Set log level to TRACE to view Stacktrace.", placeholder, expressionContext.getClass(), e.getMessage()));
                this.logger.trace("Reason for skipping expression:", e);
                if (this.leaveEmptyOnExpressionError()) {
                    this.replace(paragraphWrapper, placeholder, "");
                    continue;
                }
                if (!this.replaceUnresolvedExpressions()) continue;
                this.replace(paragraphWrapper, placeholder, this.unresolvedExpressionsDefaultValue());
            }
        }
        if (this.lineBreakPlaceholder() != null) {
            this.replaceLineBreaks(paragraphWrapper);
        }
    }

    private void replace(ParagraphWrapper p, String placeholder, R replacementRun) {
        p.replace(placeholder, replacementRun == null ? RunUtil.create("") : replacementRun);
    }

    private boolean isFailOnUnresolvedExpression() {
        return this.failOnUnresolvedExpression;
    }

    private boolean leaveEmptyOnExpressionError() {
        return this.leaveEmptyOnExpressionError;
    }

    public void replace(ParagraphWrapper p, String placeholder, String replacementObject) {
        Optional.ofNullable(replacementObject).map(replacementStr -> RunUtil.create(replacementStr, p.getParagraph())).ifPresent(replacementRun -> this.replace(p, placeholder, (R)replacementRun));
    }

    private boolean replaceUnresolvedExpressions() {
        return this.replaceUnresolvedExpressions;
    }

    private String unresolvedExpressionsDefaultValue() {
        return this.unresolvedExpressionsDefaultValue;
    }

    private String lineBreakPlaceholder() {
        return this.lineBreakPlaceholder;
    }

    private void replaceLineBreaks(ParagraphWrapper paragraphWrapper) {
        Br lineBreak = Context.getWmlObjectFactory().createBr();
        R run = RunUtil.create(lineBreak);
        while (paragraphWrapper.getText().contains(this.lineBreakPlaceholder())) {
            this.replace(paragraphWrapper, this.lineBreakPlaceholder(), run);
        }
    }
}

