/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.replace.typeresolver.image;

import java.util.Random;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.R;
import org.wickedsource.docxstamper.api.DocxStamperException;
import org.wickedsource.docxstamper.api.typeresolver.ITypeResolver;
import org.wickedsource.docxstamper.replace.typeresolver.image.Image;

public class ImageResolver
implements ITypeResolver<Image> {
    private static final Random random = new Random();

    @Override
    public R resolve(WordprocessingMLPackage document, Image image) {
        try {
            return ImageResolver.createRunWithImage(image.getFilename(), image.getAltText(), image.getMaxWidth(), BinaryPartAbstractImage.createImagePart((WordprocessingMLPackage)document, (byte[])image.getImageBytes()));
        }
        catch (Exception e) {
            throw new DocxStamperException("Error while adding image to document!", e);
        }
    }

    public static R createRunWithImage(String filenameHint, String altText, Integer maxWidth, BinaryPartAbstractImage abstractImage) {
        int id1 = random.nextInt(100000);
        int id2 = random.nextInt(100000);
        if (filenameHint == null) {
            filenameHint = "dummyFileName";
        }
        if (altText == null) {
            altText = "dummyAltText";
        }
        Inline inline = ImageResolver.tryCreateImageInline(filenameHint, altText, maxWidth, abstractImage, id1, id2);
        ObjectFactory factory = new ObjectFactory();
        R run = factory.createR();
        Drawing drawing = factory.createDrawing();
        run.getContent().add(drawing);
        drawing.getAnchorOrInline().add(inline);
        return run;
    }

    private static Inline tryCreateImageInline(String filenameHint, String altText, Integer maxWidth, BinaryPartAbstractImage abstractImage, int id1, int id2) {
        try {
            return maxWidth == null ? abstractImage.createImageInline(filenameHint, altText, (long)id1, id2, false) : abstractImage.createImageInline(filenameHint, altText, (long)id1, id2, false, maxWidth.intValue());
        }
        catch (Exception e) {
            throw new DocxStamperException(e);
        }
    }
}

