/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.util;

import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import org.docx4j.TextUtils;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.CommentsPart;
import org.docx4j.wml.CommentRangeEnd;
import org.docx4j.wml.CommentRangeStart;
import org.docx4j.wml.Comments;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wickedsource.docxstamper.api.DocxStamperException;
import org.wickedsource.docxstamper.util.CommentWrapper;
import org.wickedsource.docxstamper.util.ParagraphWrapper;
import org.wickedsource.docxstamper.util.walk.BaseDocumentWalker;

public class CommentUtil {
    private static final Logger logger = LoggerFactory.getLogger(CommentUtil.class);

    private CommentUtil() {
    }

    public static Optional<Comments.Comment> getCommentAround(R run, WordprocessingMLPackage document) {
        try {
            if (run != null) {
                ContentAccessor parent = (ContentAccessor)run.getParent();
                if (parent == null) {
                    return Optional.empty();
                }
                CommentRangeStart possibleComment = null;
                boolean foundChild = false;
                for (Object contentElement : parent.getContent()) {
                    if (XmlUtils.unwrap(contentElement) instanceof CommentRangeStart) {
                        possibleComment = (CommentRangeStart)contentElement;
                        continue;
                    }
                    if (possibleComment != null && run.equals(contentElement)) {
                        foundChild = true;
                        continue;
                    }
                    if (possibleComment != null && foundChild && XmlUtils.unwrap(contentElement) instanceof CommentRangeEnd) {
                        try {
                            BigInteger id = possibleComment.getId();
                            CommentsPart commentsPart = (CommentsPart)document.getParts().get(new PartName("/word/comments.xml"));
                            Comments comments = (Comments)commentsPart.getContents();
                            for (Comments.Comment comment : comments.getComment()) {
                                if (!comment.getId().equals(id)) continue;
                                return Optional.of(comment);
                            }
                            continue;
                        }
                        catch (InvalidFormatException e) {
                            logger.warn(String.format("Error while searching comment. Skipping run %s.", run), (Throwable)e);
                            continue;
                        }
                    }
                    possibleComment = null;
                    foundChild = false;
                }
            }
            return Optional.empty();
        }
        catch (Docx4JException e) {
            throw new DocxStamperException("error accessing the comments of the document!", e);
        }
    }

    public static String getCommentStringFor(ContentAccessor object, WordprocessingMLPackage document) {
        Comments.Comment comment = CommentUtil.getCommentFor(object, document).orElseThrow();
        return CommentUtil.getCommentString(comment);
    }

    public static Optional<Comments.Comment> getCommentFor(ContentAccessor object, WordprocessingMLPackage document) {
        for (Object contentObject : object.getContent()) {
            Comments comments;
            PartName partName;
            if (!(contentObject instanceof CommentRangeStart)) continue;
            BigInteger id = ((CommentRangeStart)contentObject).getId();
            try {
                partName = new PartName("/word/comments.xml");
            }
            catch (InvalidFormatException e) {
                logger.warn(String.format("Error while searching comment. Skipping object %s.", object), (Throwable)e);
                throw new DocxStamperException("error accessing the comments of the document!", e);
            }
            CommentsPart commentsPart = (CommentsPart)document.getParts().get(partName);
            try {
                comments = (Comments)commentsPart.getContents();
            }
            catch (Docx4JException e) {
                throw new DocxStamperException("error accessing the comments of the document!", e);
            }
            for (Comments.Comment comment : comments.getComment()) {
                if (!comment.getId().equals(id)) continue;
                return Optional.of(comment);
            }
        }
        return Optional.empty();
    }

    public static String getCommentString(Comments.Comment comment) {
        StringBuilder builder = new StringBuilder();
        for (Object commentChildObject : comment.getContent()) {
            if (!(commentChildObject instanceof P)) continue;
            builder.append(new ParagraphWrapper((P)commentChildObject).getText());
        }
        return builder.toString();
    }

    public static void deleteComment(CommentWrapper comment) {
        if (comment.getCommentRangeEnd() != null) {
            ContentAccessor commentRangeEndParent = (ContentAccessor)comment.getCommentRangeEnd().getParent();
            commentRangeEndParent.getContent().remove(comment.getCommentRangeEnd());
        }
        if (comment.getCommentRangeStart() != null) {
            ContentAccessor commentRangeStartParent = (ContentAccessor)comment.getCommentRangeStart().getParent();
            commentRangeStartParent.getContent().remove(comment.getCommentRangeStart());
        }
        if (comment.getCommentReference() != null) {
            ContentAccessor commentReferenceParent = (ContentAccessor)comment.getCommentReference().getParent();
            commentReferenceParent.getContent().remove(comment.getCommentReference());
        }
    }

    public static void deleteCommentFromElement(ContentAccessor element, BigInteger commentId) {
        ArrayList elementsToRemove = new ArrayList();
        for (Object obj : element.getContent()) {
            Object unwrapped = XmlUtils.unwrap(obj);
            if (unwrapped instanceof CommentRangeStart) {
                if (!((CommentRangeStart)unwrapped).getId().equals(commentId)) continue;
                elementsToRemove.add(obj);
                continue;
            }
            if (unwrapped instanceof CommentRangeEnd) {
                if (!((CommentRangeEnd)unwrapped).getId().equals(commentId)) continue;
                elementsToRemove.add(obj);
                continue;
            }
            if (unwrapped instanceof R.CommentReference) {
                if (!((R.CommentReference)unwrapped).getId().equals(commentId)) continue;
                elementsToRemove.add(obj);
                continue;
            }
            if (!(unwrapped instanceof ContentAccessor)) continue;
            CommentUtil.deleteCommentFromElement((ContentAccessor)unwrapped, commentId);
        }
        element.getContent().removeAll(elementsToRemove);
    }

    public static Map<BigInteger, CommentWrapper> getComments(WordprocessingMLPackage document) {
        HashMap<BigInteger, CommentWrapper> rootComments = new HashMap<BigInteger, CommentWrapper>();
        HashMap<BigInteger, CommentWrapper> allComments = new HashMap<BigInteger, CommentWrapper>();
        CommentUtil.collectCommentRanges(rootComments, allComments, document);
        CommentUtil.collectComments(allComments, document);
        return CommentUtil.cleanMalformedComments(rootComments);
    }

    private static Map<BigInteger, CommentWrapper> cleanMalformedComments(Map<BigInteger, CommentWrapper> rootComments) {
        HashMap<BigInteger, CommentWrapper> filteredCommentEntries = new HashMap<BigInteger, CommentWrapper>();
        rootComments.forEach((key, comment) -> {
            if (CommentUtil.isCommentMalformed(comment)) {
                logger.error("Skipping malformed comment, missing range start and/or range end : {}", (Object)CommentUtil.getCommentContent(comment));
            } else {
                filteredCommentEntries.put((BigInteger)key, (CommentWrapper)comment);
                comment.setChildren(CommentUtil.cleanMalformedComments(comment.getChildren()));
            }
        });
        return filteredCommentEntries;
    }

    private static Set<CommentWrapper> cleanMalformedComments(Set<CommentWrapper> children) {
        return children.stream().filter(comment -> {
            if (CommentUtil.isCommentMalformed(comment)) {
                logger.error("Skipping malformed comment, missing range start and/or range end : {}", (Object)CommentUtil.getCommentContent(comment));
                return false;
            }
            comment.setChildren(CommentUtil.cleanMalformedComments(comment.getChildren()));
            return true;
        }).collect(Collectors.toSet());
    }

    private static String getCommentContent(CommentWrapper comment) {
        return comment.getComment() != null ? comment.getComment().getContent().stream().map(TextUtils::getText).collect(Collectors.joining("")) : "<no content>";
    }

    private static boolean isCommentMalformed(CommentWrapper comment) {
        return comment.getCommentRangeStart() == null || comment.getCommentRangeEnd() == null || comment.getComment() == null;
    }

    private static void collectCommentRanges(final Map<BigInteger, CommentWrapper> rootComments, final Map<BigInteger, CommentWrapper> allComments, WordprocessingMLPackage document) {
        final Queue stack = Collections.asLifoQueue(new ArrayDeque());
        BaseDocumentWalker documentWalker = new BaseDocumentWalker((ContentAccessor)document.getMainDocumentPart()){

            @Override
            protected void onCommentRangeStart(CommentRangeStart commentRangeStart) {
                CommentWrapper commentWrapper = (CommentWrapper)allComments.get(commentRangeStart.getId());
                if (commentWrapper == null) {
                    commentWrapper = new CommentWrapper();
                    allComments.put(commentRangeStart.getId(), commentWrapper);
                    if (stack.isEmpty()) {
                        rootComments.put(commentRangeStart.getId(), commentWrapper);
                    } else {
                        ((CommentWrapper)stack.peek()).getChildren().add(commentWrapper);
                    }
                }
                commentWrapper.setCommentRangeStart(commentRangeStart);
                stack.add(commentWrapper);
            }

            @Override
            protected void onCommentRangeEnd(CommentRangeEnd commentRangeEnd) {
                CommentWrapper commentWrapper = (CommentWrapper)allComments.get(commentRangeEnd.getId());
                if (commentWrapper == null) {
                    throw new RuntimeException("Found a comment range end before the comment range start !");
                }
                commentWrapper.setCommentRangeEnd(commentRangeEnd);
                if (!stack.isEmpty()) {
                    if (((CommentWrapper)stack.peek()).equals(commentWrapper)) {
                        stack.remove();
                    } else {
                        throw new RuntimeException("Cannot figure which comment contains the other !");
                    }
                }
            }

            @Override
            protected void onCommentReference(R.CommentReference commentReference) {
                CommentWrapper commentWrapper = (CommentWrapper)allComments.get(commentReference.getId());
                if (commentWrapper == null) {
                    throw new RuntimeException("Found a comment reference before the comment range start !");
                }
                commentWrapper.setCommentReference(commentReference);
            }
        };
        documentWalker.walk();
    }

    private static void collectComments(Map<BigInteger, CommentWrapper> allComments, WordprocessingMLPackage document) {
        try {
            CommentsPart commentsPart = (CommentsPart)document.getParts().get(new PartName("/word/comments.xml"));
            if (commentsPart != null) {
                for (Comments.Comment comment : ((Comments)commentsPart.getContents()).getComment()) {
                    CommentWrapper commentWrapper = allComments.get(comment.getId());
                    if (commentWrapper == null) continue;
                    commentWrapper.setComment(comment);
                }
            }
        }
        catch (Docx4JException e) {
            throw new IllegalStateException(e);
        }
    }
}

