/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.util;

import jakarta.xml.bind.JAXBElement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.docx4j.TraversalUtil;
import org.docx4j.dml.Graphic;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.finders.ClassFinder;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Tr;
import org.wickedsource.docxstamper.api.DocxStamperException;
import org.wickedsource.docxstamper.replace.typeresolver.image.ImageResolver;
import org.wickedsource.docxstamper.util.DocxImageExtractor;

public class DocumentUtil {
    private DocumentUtil() {
        throw new DocxStamperException("Utility classes shouldn't be instantiated");
    }

    public static <T> List<T> extractElements(Object object, Class<T> elementClass) {
        if (object instanceof WordprocessingMLPackage) {
            WordprocessingMLPackage document = (WordprocessingMLPackage)object;
            return Stream.of(DocumentUtil.getElementStreamFrom(document, elementClass, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/header"), DocumentUtil.getElementStream(document.getMainDocumentPart(), elementClass), DocumentUtil.getElementStreamFrom(document, elementClass, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer")).flatMap(Function.identity()).collect(Collectors.toList());
        }
        return DocumentUtil.getElementStream(object, elementClass).collect(Collectors.toList());
    }

    private static <T> Stream<T> getElementStreamFrom(WordprocessingMLPackage document, Class<T> clazz, String relationshipType) {
        RelationshipsPart relationshipsPart = document.getMainDocumentPart().getRelationshipsPart();
        return relationshipsPart.getRelationships().getRelationship().stream().filter(relationship -> relationship.getType().equals(relationshipType)).map(arg_0 -> ((RelationshipsPart)relationshipsPart).getPart(arg_0)).flatMap(relationshipPart -> DocumentUtil.getElementStream(relationshipPart, clazz));
    }

    private static <T> Stream<T> getElementStream(Object obj, Class<T> clazz) {
        ClassFinder finder = new ClassFinder(clazz);
        finder.walkJAXBElements(obj);
        return finder.results.stream().map(clazz::cast);
    }

    public static String getImageRelationshipId(Drawing drawing) {
        Graphic graphic = DocumentUtil.getInlineGraphic(drawing);
        return graphic.getGraphicData().getPic().getBlipFill().getBlip().getEmbed();
    }

    private static Graphic getInlineGraphic(Drawing drawing) {
        if (drawing.getAnchorOrInline().isEmpty()) {
            throw new RuntimeException("Anchor or Inline is empty !");
        }
        Object anchorOrInline = drawing.getAnchorOrInline().get(0);
        if (anchorOrInline instanceof Inline) {
            Inline inline = (Inline)anchorOrInline;
            return inline.getGraphic();
        }
        throw new RuntimeException("Don't know how to process anchor !");
    }

    public static List<P> getParagraphsFromObject(Object parentObject) {
        ArrayList<P> paragraphList = new ArrayList<P>();
        for (Object object : DocumentUtil.getElementsFromObject(parentObject, P.class)) {
            if (!(object instanceof P)) continue;
            paragraphList.add((P)object);
        }
        return paragraphList;
    }

    private static List<Object> getElementsFromObject(Object object, Class<?> elementClass) {
        ArrayList<Object> documentElements = new ArrayList<Object>();
        if (object instanceof WordprocessingMLPackage) {
            documentElements.addAll(DocumentUtil.getElementsFromHeader((WordprocessingMLPackage)object, elementClass));
            documentElements.addAll(DocumentUtil.getElements(((WordprocessingMLPackage)object).getMainDocumentPart(), elementClass));
            documentElements.addAll(DocumentUtil.getElementsForFooter((WordprocessingMLPackage)object, elementClass));
        } else {
            documentElements.addAll(DocumentUtil.getElements(object, elementClass));
        }
        return documentElements;
    }

    private static List<Object> getElementsFromHeader(WordprocessingMLPackage document, Class<?> elementClass) {
        ArrayList<Object> paragraphs = new ArrayList<Object>();
        RelationshipsPart relationshipsPart = document.getMainDocumentPart().getRelationshipsPart();
        List<Relationship> relationships = DocumentUtil.getRelationshipsOfType(document, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/header");
        for (Relationship header : relationships) {
            HeaderPart headerPart = (HeaderPart)relationshipsPart.getPart(header.getId());
            paragraphs.addAll(DocumentUtil.getElements(headerPart, elementClass));
        }
        return paragraphs;
    }

    private static List<Object> getElements(Object obj, Class<?> elementClass) {
        ClassFinder finder = new ClassFinder(elementClass);
        TraversalUtil.visit((Object)obj, (TraversalUtil.Callback)finder);
        return finder.results;
    }

    private static List<Object> getElementsForFooter(WordprocessingMLPackage document, Class<?> elementClass) {
        ArrayList<Object> paragraphs = new ArrayList<Object>();
        RelationshipsPart relationshipsPart = document.getMainDocumentPart().getRelationshipsPart();
        List<Relationship> relationships = DocumentUtil.getRelationshipsOfType(document, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer");
        for (Relationship footer : relationships) {
            FooterPart footerPart = (FooterPart)relationshipsPart.getPart(footer.getId());
            paragraphs.addAll(DocumentUtil.getElements(footerPart, elementClass));
        }
        return paragraphs;
    }

    private static List<Relationship> getRelationshipsOfType(WordprocessingMLPackage document, String type) {
        List relationshipList = document.getMainDocumentPart().getRelationshipsPart().getRelationships().getRelationship();
        ArrayList<Relationship> headerRelationships = new ArrayList<Relationship>();
        for (Relationship r : relationshipList) {
            if (!r.getType().equals(type)) continue;
            headerRelationships.add(r);
        }
        return headerRelationships;
    }

    public static List<Tbl> getTableFromObject(Object parentObject) {
        ArrayList<Tbl> tableList = new ArrayList<Tbl>();
        for (Object object : DocumentUtil.getElementsFromObject(parentObject, Tbl.class)) {
            if (!(object instanceof Tbl)) continue;
            tableList.add((Tbl)object);
        }
        return tableList;
    }

    public static List<Tr> getTableRowsFromObject(Object parentObject) {
        ArrayList<Tr> tableRowList = new ArrayList<Tr>();
        for (Object object : DocumentUtil.getElementsFromObject(parentObject, Tr.class)) {
            if (!(object instanceof Tr)) continue;
            tableRowList.add((Tr)object);
        }
        return tableRowList;
    }

    public static List<Tc> getTableCellsFromObject(Object parentObject) {
        return DocumentUtil.getElementsFromObject(parentObject, Tc.class).stream().filter(object -> object instanceof Tc).map(object -> (Tc)object).toList();
    }

    public static Object lastElement(WordprocessingMLPackage subDocument) {
        List content = subDocument.getMainDocumentPart().getContent();
        return content.get(content.size() - 1);
    }

    public static List<Object> allElements(WordprocessingMLPackage subDocument) {
        return subDocument.getMainDocumentPart().getContent();
    }

    public static Map<R, R> walkObjectsAndImportImages(WordprocessingMLPackage source, WordprocessingMLPackage target) {
        return DocumentUtil.walkObjectsAndImportImages((ContentAccessor)source.getMainDocumentPart(), source, target);
    }

    public static Map<R, R> walkObjectsAndImportImages(ContentAccessor container, WordprocessingMLPackage source, WordprocessingMLPackage target) {
        HashMap<R, R> replacements = new HashMap<R, R>();
        for (Object obj : container.getContent()) {
            ArrayDeque queue = new ArrayDeque();
            queue.add(obj);
            while (!queue.isEmpty()) {
                R currentR;
                Object currentObj = queue.remove();
                if (currentObj instanceof R && DocumentUtil.isImageRun(currentR = (R)currentObj)) {
                    DocxImageExtractor docxImageExtractor = new DocxImageExtractor(source);
                    byte[] imageData = docxImageExtractor.getRunDrawingData(currentR);
                    String filename = docxImageExtractor.getRunDrawingFilename(currentR);
                    String alt = docxImageExtractor.getRunDrawingAltText(currentR);
                    Integer maxWidth = docxImageExtractor.getRunDrawingMaxWidth(currentR);
                    BinaryPartAbstractImage imagePart = DocumentUtil.tryCreateImagePart(target, imageData);
                    replacements.put(currentR, ImageResolver.createRunWithImage(filename, alt, maxWidth, imagePart));
                    continue;
                }
                if (!(currentObj instanceof ContentAccessor)) continue;
                ContentAccessor contentAccessor = (ContentAccessor)currentObj;
                queue.addAll(contentAccessor.getContent());
            }
        }
        return replacements;
    }

    private static boolean isImageRun(R run) {
        return run.getContent().stream().filter(runElement -> runElement instanceof JAXBElement).map(JAXBElement.class::cast).map(JAXBElement::getValue).anyMatch(runValue -> runValue instanceof Drawing);
    }

    private static BinaryPartAbstractImage tryCreateImagePart(WordprocessingMLPackage destDocument, byte[] imageData) {
        try {
            return BinaryPartAbstractImage.createImagePart((WordprocessingMLPackage)destDocument, (byte[])imageData);
        }
        catch (Exception e) {
            throw new DocxStamperException(e);
        }
    }
}

