/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.util;

import org.docx4j.wml.R;
import org.wickedsource.docxstamper.util.RunUtil;

public class IndexedRun {
    private final int startIndex;
    private final int endIndex;
    private final int indexInParent;
    private final R run;

    public IndexedRun(int startIndex, int endIndex, int indexInParent, R run) {
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.indexInParent = indexInParent;
        this.run = run;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public int getIndexInParent() {
        return this.indexInParent;
    }

    public R getRun() {
        return this.run;
    }

    public boolean isTouchedByRange(int globalStartIndex, int globalEndIndex) {
        return this.startIndex >= globalStartIndex && this.startIndex <= globalEndIndex || this.endIndex >= globalStartIndex && this.endIndex <= globalEndIndex || this.startIndex <= globalStartIndex && this.endIndex >= globalEndIndex;
    }

    public void replace(int globalStartIndex, int globalEndIndex, String replacement) {
        int localStartIndex = this.globalIndexToLocalIndex(globalStartIndex);
        int localEndIndex = this.globalIndexToLocalIndex(globalEndIndex);
        Object text = RunUtil.getText(this.run);
        text = ((String)text).substring(0, localStartIndex);
        text = (String)text + replacement;
        String runText = RunUtil.getText(this.run);
        if (runText.length() > 0) {
            text = (String)text + RunUtil.getText(this.run).substring(localEndIndex + 1);
        }
        RunUtil.setText(this.run, (String)text);
    }

    private int globalIndexToLocalIndex(int globalIndex) {
        if (globalIndex < this.startIndex) {
            return 0;
        }
        if (globalIndex > this.endIndex) {
            return RunUtil.getText(this.run).length() - 1;
        }
        return globalIndex - this.startIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IndexedRun)) {
            return false;
        }
        IndexedRun that = (IndexedRun)o;
        if (this.endIndex != that.endIndex) {
            return false;
        }
        if (this.indexInParent != that.indexInParent) {
            return false;
        }
        return this.startIndex == that.startIndex;
    }

    public int hashCode() {
        int result = this.startIndex;
        result = 31 * result + this.endIndex;
        result = 31 * result + this.indexInParent;
        return result;
    }

    public String toString() {
        return String.format("[IndexedRun: startIndex=%d; endIndex=%d; indexInParent=%d text=%s}", this.startIndex, this.endIndex, this.indexInParent, RunUtil.getText(this.run));
    }
}

