/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.wickedsource.docxstamper.util.IndexedRun;
import org.wickedsource.docxstamper.util.RunUtil;

public class ParagraphWrapper {
    private final List<IndexedRun> runs = new ArrayList<IndexedRun>();
    private final P paragraph;
    private int currentPosition = 0;

    public ParagraphWrapper(P paragraph) {
        this.paragraph = paragraph;
        this.recalculateRuns();
    }

    public void recalculateRuns() {
        this.currentPosition = 0;
        this.runs.clear();
        int index = 0;
        for (Object contentElement : this.paragraph.getContent()) {
            if (contentElement instanceof R && !RunUtil.getText((R)contentElement).equals("")) {
                this.addRun((R)contentElement, index);
            }
            ++index;
        }
    }

    private void addRun(R run, int index) {
        int startIndex = this.currentPosition;
        int endIndex = this.currentPosition + RunUtil.getText(run).length() - 1;
        this.runs.add(new IndexedRun(startIndex, endIndex, index, run));
        this.currentPosition = endIndex + 1;
    }

    public void replace(String placeholder, R replacement) {
        boolean singleRun;
        String text = this.getText();
        int matchStartIndex = text.indexOf(placeholder);
        if (matchStartIndex == -1) {
            return;
        }
        int matchEndIndex = matchStartIndex + placeholder.length() - 1;
        List<IndexedRun> affectedRuns = this.getAffectedRuns(matchStartIndex, matchEndIndex);
        boolean bl = singleRun = affectedRuns.size() == 1;
        if (singleRun) {
            IndexedRun run = affectedRuns.get(0);
            boolean placeholderSpansCompleteRun = placeholder.length() == RunUtil.getText(run.getRun()).length();
            boolean placeholderAtStartOfRun = matchStartIndex == run.getStartIndex();
            boolean placeholderAtEndOfRun = matchEndIndex == run.getEndIndex();
            boolean placeholderWithinRun = matchStartIndex > run.getStartIndex() && matchEndIndex < run.getEndIndex();
            replacement.setRPr(run.getRun().getRPr());
            if (placeholderSpansCompleteRun) {
                this.paragraph.getContent().remove(run.getRun());
                this.paragraph.getContent().add(run.getIndexInParent(), replacement);
                this.recalculateRuns();
            } else if (placeholderAtStartOfRun) {
                run.replace(matchStartIndex, matchEndIndex, "");
                this.paragraph.getContent().add(run.getIndexInParent(), replacement);
                this.recalculateRuns();
            } else if (placeholderAtEndOfRun) {
                run.replace(matchStartIndex, matchEndIndex, "");
                this.paragraph.getContent().add(run.getIndexInParent() + 1, replacement);
                this.recalculateRuns();
            } else if (placeholderWithinRun) {
                String runText = RunUtil.getText(run.getRun());
                int startIndex = runText.indexOf(placeholder);
                int endIndex = startIndex + placeholder.length();
                R run1 = RunUtil.create(runText.substring(0, startIndex), this.paragraph);
                R run2 = RunUtil.create(runText.substring(endIndex), this.paragraph);
                this.paragraph.getContent().add(run.getIndexInParent(), run2);
                this.paragraph.getContent().add(run.getIndexInParent(), replacement);
                this.paragraph.getContent().add(run.getIndexInParent(), run1);
                this.paragraph.getContent().remove(run.getRun());
                this.recalculateRuns();
            }
        } else {
            IndexedRun firstRun = affectedRuns.get(0);
            IndexedRun lastRun = affectedRuns.get(affectedRuns.size() - 1);
            replacement.setRPr(firstRun.getRun().getRPr());
            firstRun.replace(matchStartIndex, matchEndIndex, "");
            lastRun.replace(matchStartIndex, matchEndIndex, "");
            for (IndexedRun run : affectedRuns) {
                if (Objects.equals(run, firstRun) || Objects.equals(run, lastRun)) continue;
                this.paragraph.getContent().remove(run.getRun());
            }
            this.paragraph.getContent().add(firstRun.getIndexInParent() + 1, replacement);
            this.recalculateRuns();
        }
    }

    public String getText() {
        return this.runs.stream().map(IndexedRun::getRun).map(RunUtil::getText).collect(Collectors.joining());
    }

    private List<IndexedRun> getAffectedRuns(int startIndex, int endIndex) {
        return this.runs.stream().filter(run -> run.isTouchedByRange(startIndex, endIndex)).toList();
    }

    public List<R> getRuns() {
        return this.runs.stream().map(IndexedRun::getRun).toList();
    }

    public String toString() {
        return this.getText();
    }

    public P getParagraph() {
        return this.paragraph;
    }
}

