/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.util;

import java.util.List;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.SectPr;

public class SectionUtil {
    private static final ObjectFactory factory = Context.getWmlObjectFactory();

    public static SectPr getPreviousSectionBreakIfPresent(Object firstObject, ContentAccessor parent) {
        List parentContent = parent.getContent();
        int pIndex = parentContent.indexOf(firstObject);
        for (int i = pIndex - 1; i >= 0; --i) {
            Object e = parentContent.get(i);
            if (!(e instanceof P)) continue;
            P prevParagraph = (P)e;
            PPr pPr = prevParagraph.getPPr();
            if (pPr != null && pPr.getSectPr() != null) {
                return pPr.getSectPr();
            }
            return null;
        }
        System.out.println("No previous section break found from : " + parent + ", first object index=" + pIndex);
        return null;
    }

    public static SectPr getParagraphSectionBreak(P p) {
        return p.getPPr() != null && p.getPPr().getSectPr() != null ? p.getPPr().getSectPr() : null;
    }

    public static boolean isOddNumberOfSectionBreaks(List<Object> objects) {
        long count = objects.stream().filter(obj -> obj instanceof P).map(obj -> (P)obj).filter(p -> p.getPPr() != null && p.getPPr().getSectPr() != null).count();
        return count % 2L != 0L;
    }

    public static void applySectionBreakToParagraph(SectPr sectPr, P paragraph) {
        PPr pPpr = paragraph.getPPr();
        PPr nextPPr = pPpr != null ? pPpr : factory.createPPr();
        nextPPr.setSectPr((SectPr)XmlUtils.deepCopy((Object)sectPr));
        paragraph.setPPr(nextPPr);
    }
}

