/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper;

import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.wickedsource.docxstamper.CommentProcessorBuilder;
import org.wickedsource.docxstamper.DocxStamperConfiguration;
import org.wickedsource.docxstamper.api.DocxStamperException;
import org.wickedsource.docxstamper.api.EvaluationContextConfigurer;
import org.wickedsource.docxstamper.api.preprocessor.PreProcessor;
import org.wickedsource.docxstamper.api.typeresolver.ITypeResolver;
import org.wickedsource.docxstamper.api.typeresolver.TypeResolverRegistry;
import org.wickedsource.docxstamper.el.ExpressionResolver;
import org.wickedsource.docxstamper.el.StandardMethodResolver;
import org.wickedsource.docxstamper.processor.CommentProcessorRegistry;
import org.wickedsource.docxstamper.replace.PlaceholderReplacer;
import org.wickedsource.docxstamper.replace.typeresolver.DateResolver;
import org.wickedsource.docxstamper.replace.typeresolver.LocalDateResolver;
import org.wickedsource.docxstamper.replace.typeresolver.LocalDateTimeResolver;
import org.wickedsource.docxstamper.replace.typeresolver.LocalTimeResolver;
import org.wickedsource.docxstamper.replace.typeresolver.image.Image;
import org.wickedsource.docxstamper.replace.typeresolver.image.ImageResolver;
import pro.verron.docxstamper.OpcStamper;

public class DocxStamper<T>
implements OpcStamper<WordprocessingMLPackage> {
    private final List<PreProcessor> preprocessors;
    private final PlaceholderReplacer placeholderReplacer;
    private final CommentProcessorRegistry commentProcessorRegistry;

    @Deprecated(since="1.6.4", forRemoval=true)
    public DocxStamper() {
        this(new DocxStamperConfiguration());
    }

    public DocxStamper(DocxStamperConfiguration configuration) {
        this(configuration.isFailOnUnresolvedExpression(), configuration.isReplaceUnresolvedExpressions(), configuration.isLeaveEmptyOnExpressionError(), configuration.getUnresolvedExpressionsDefaultValue(), configuration.getLineBreakPlaceholder(), configuration.getEvaluationContextConfigurer(), configuration.getExpressionFunctions(), DocxStamper.configureTypeResolverRegistry(configuration.getTypeResolvers(), configuration.getDefaultTypeResolver()), configuration.getCommentProcessors(), configuration.isReplaceNullValues(), configuration.getNullValuesDefault(), configuration.getPreprocessors(), configuration.getSpelParserConfiguration());
    }

    private DocxStamper(boolean failOnUnresolvedExpression, boolean replaceUnresolvedExpressions, boolean leaveEmptyOnExpressionError, String unresolvedExpressionsDefaultValue, String lineBreakPlaceholder, EvaluationContextConfigurer evaluationContextConfigurer, Map<Class<?>, Object> expressionFunctions, TypeResolverRegistry typeResolverRegistry, Map<Class<?>, CommentProcessorBuilder> configurationCommentProcessors, boolean replaceNullValues, String nullValuesDefault, List<PreProcessor> preprocessors, SpelParserConfiguration spelParserConfiguration) {
        HashMap commentProcessors = new HashMap();
        Function<ReflectiveOperationException, TypedValue> onResolutionFail = failOnUnresolvedExpression ? DocxStamper::throwException : exception -> new TypedValue(null);
        StandardMethodResolver methodResolver = new StandardMethodResolver(commentProcessors, expressionFunctions, onResolutionFail);
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
        evaluationContextConfigurer.configureEvaluationContext(evaluationContext);
        evaluationContext.addMethodResolver((MethodResolver)methodResolver);
        ExpressionResolver expressionResolver = new ExpressionResolver(evaluationContext, spelParserConfiguration);
        PlaceholderReplacer placeholderReplacerInstance = new PlaceholderReplacer(typeResolverRegistry, expressionResolver, replaceNullValues, nullValuesDefault, failOnUnresolvedExpression, replaceUnresolvedExpressions, unresolvedExpressionsDefaultValue, leaveEmptyOnExpressionError, lineBreakPlaceholder);
        for (Map.Entry<Class<?>, CommentProcessorBuilder> entry : configurationCommentProcessors.entrySet()) {
            commentProcessors.put(entry.getKey(), entry.getValue().create(placeholderReplacerInstance));
        }
        CommentProcessorRegistry commentProcessorRegistryInstance = new CommentProcessorRegistry(placeholderReplacerInstance, expressionResolver, commentProcessors, failOnUnresolvedExpression);
        this.placeholderReplacer = placeholderReplacerInstance;
        this.commentProcessorRegistry = commentProcessorRegistryInstance;
        this.preprocessors = preprocessors.stream().toList();
    }

    private static TypeResolverRegistry configureTypeResolverRegistry(Map<Class<?>, ITypeResolver<?>> typeResolvers, ITypeResolver<Object> defaultResolver) {
        TypeResolverRegistry typeResolverRegistry = new TypeResolverRegistry(defaultResolver);
        typeResolverRegistry.registerTypeResolver(Image.class, new ImageResolver());
        typeResolverRegistry.registerTypeResolver(Date.class, new DateResolver());
        typeResolverRegistry.registerTypeResolver(LocalDate.class, new LocalDateResolver());
        typeResolverRegistry.registerTypeResolver(LocalDateTime.class, new LocalDateTimeResolver());
        typeResolverRegistry.registerTypeResolver(LocalTime.class, new LocalTimeResolver());
        for (Map.Entry<Class<?>, ITypeResolver<?>> entry : typeResolvers.entrySet()) {
            typeResolverRegistry.registerTypeResolver(entry.getKey(), entry.getValue());
        }
        return typeResolverRegistry;
    }

    private static TypedValue throwException(ReflectiveOperationException exception) {
        throw new DocxStamperException("Error calling method", exception);
    }

    @Override
    public void stamp(InputStream template, Object contextRoot, OutputStream out) throws DocxStamperException {
        try {
            WordprocessingMLPackage document = WordprocessingMLPackage.load((InputStream)template);
            this.stamp(document, contextRoot, out);
        }
        catch (Docx4JException e) {
            throw new DocxStamperException(e);
        }
    }

    @Override
    public void stamp(WordprocessingMLPackage document, Object contextRoot, OutputStream out) throws DocxStamperException {
        try {
            this.preprocess(document);
            this.processComments(document, contextRoot);
            this.replaceExpressions(document, contextRoot);
            document.save(out);
            this.commentProcessorRegistry.reset();
        }
        catch (Docx4JException e) {
            throw new DocxStamperException(e);
        }
    }

    private void preprocess(WordprocessingMLPackage document) {
        for (PreProcessor preprocessor : this.preprocessors) {
            preprocessor.process(document);
        }
    }

    private void processComments(WordprocessingMLPackage document, Object contextObject) {
        this.commentProcessorRegistry.runProcessors(document, contextObject);
    }

    private void replaceExpressions(WordprocessingMLPackage document, Object contextObject) {
        this.placeholderReplacer.resolveExpressions(document, contextObject);
    }
}

