/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.wickedsource.docxstamper.CommentProcessorBuilder;
import org.wickedsource.docxstamper.DocxStamper;
import org.wickedsource.docxstamper.api.EvaluationContextConfigurer;
import org.wickedsource.docxstamper.api.preprocessor.PreProcessor;
import org.wickedsource.docxstamper.api.typeresolver.ITypeResolver;
import org.wickedsource.docxstamper.el.DefaultEvaluationContextConfigurer;
import org.wickedsource.docxstamper.processor.CommentProcessorFactory;
import org.wickedsource.docxstamper.processor.displayif.IDisplayIfProcessor;
import org.wickedsource.docxstamper.processor.repeat.IParagraphRepeatProcessor;
import org.wickedsource.docxstamper.processor.repeat.IRepeatDocPartProcessor;
import org.wickedsource.docxstamper.processor.repeat.IRepeatProcessor;
import org.wickedsource.docxstamper.processor.replaceExpression.IReplaceWithProcessor;
import org.wickedsource.docxstamper.processor.table.ITableResolver;
import org.wickedsource.docxstamper.replace.typeresolver.FallbackResolver;

public class DocxStamperConfiguration {
    private final Map<Class<?>, CommentProcessorBuilder> commentProcessors = new HashMap();
    private final Map<Class<?>, ITypeResolver<?>> typeResolvers = new HashMap();
    private final Map<Class<?>, Object> expressionFunctions = new HashMap();
    private final List<PreProcessor> preprocessors = new ArrayList<PreProcessor>();
    private String lineBreakPlaceholder;
    private EvaluationContextConfigurer evaluationContextConfigurer = new DefaultEvaluationContextConfigurer();
    private boolean failOnUnresolvedExpression = true;
    private boolean leaveEmptyOnExpressionError = false;
    private boolean replaceUnresolvedExpressions = false;
    private String unresolvedExpressionsDefaultValue = null;
    private boolean replaceNullValues = false;
    private String nullValuesDefault = null;
    private ITypeResolver<Object> defaultTypeResolver = new FallbackResolver();
    private SpelParserConfiguration spelParserConfiguration = new SpelParserConfiguration();

    public DocxStamperConfiguration() {
        CommentProcessorFactory pf = new CommentProcessorFactory(this);
        this.commentProcessors.put(IRepeatProcessor.class, pf::repeat);
        this.commentProcessors.put(IParagraphRepeatProcessor.class, pf::repeatParagraph);
        this.commentProcessors.put(IRepeatDocPartProcessor.class, pf::repeatDocPart);
        this.commentProcessors.put(ITableResolver.class, pf::tableResolver);
        this.commentProcessors.put(IDisplayIfProcessor.class, pf::displayIf);
        this.commentProcessors.put(IReplaceWithProcessor.class, pf::replaceWith);
    }

    public Optional<String> nullReplacementValue() {
        return this.replaceNullValues ? Optional.ofNullable(this.nullValuesDefault) : Optional.empty();
    }

    public boolean isFailOnUnresolvedExpression() {
        return this.failOnUnresolvedExpression;
    }

    public DocxStamperConfiguration setLineBreakPlaceholder(String lineBreakPlaceholder) {
        this.lineBreakPlaceholder = lineBreakPlaceholder;
        return this;
    }

    public DocxStamperConfiguration setEvaluationContextConfigurer(EvaluationContextConfigurer evaluationContextConfigurer) {
        this.evaluationContextConfigurer = evaluationContextConfigurer;
        return this;
    }

    public DocxStamperConfiguration nullValuesDefault(String nullValuesDefault) {
        this.nullValuesDefault = nullValuesDefault;
        return this;
    }

    public DocxStamperConfiguration replaceNullValues(boolean replaceNullValues) {
        this.replaceNullValues = replaceNullValues;
        return this;
    }

    public DocxStamperConfiguration unresolvedExpressionsDefaultValue(String unresolvedExpressionsDefaultValue) {
        this.unresolvedExpressionsDefaultValue = unresolvedExpressionsDefaultValue;
        return this;
    }

    public DocxStamperConfiguration replaceUnresolvedExpressions(boolean replaceUnresolvedExpressions) {
        this.replaceUnresolvedExpressions = replaceUnresolvedExpressions;
        return this;
    }

    public DocxStamperConfiguration leaveEmptyOnExpressionError(boolean leaveEmpty) {
        this.leaveEmptyOnExpressionError = leaveEmpty;
        return this;
    }

    public <T> DocxStamperConfiguration addTypeResolver(Class<T> resolvedType, ITypeResolver<T> resolver) {
        this.typeResolvers.put(resolvedType, resolver);
        return this;
    }

    public DocxStamperConfiguration exposeInterfaceToExpressionLanguage(Class<?> interfaceClass, Object implementation) {
        this.expressionFunctions.put(interfaceClass, implementation);
        return this;
    }

    public DocxStamperConfiguration addCommentProcessor(Class<?> interfaceClass, CommentProcessorBuilder commentProcessorFactory) {
        this.commentProcessors.put(interfaceClass, commentProcessorFactory);
        return this;
    }

    @Deprecated(forRemoval=true, since="1.6.4")
    public <T> DocxStamper<T> build() {
        return new DocxStamper(this);
    }

    public DocxStamperConfiguration setDefaultTypeResolver(ITypeResolver<? super Object> defaultTypeResolver) {
        this.defaultTypeResolver = defaultTypeResolver;
        return this;
    }

    public void addPreprocessor(PreProcessor preprocessor) {
        this.preprocessors.add(preprocessor);
    }

    public DocxStamperConfiguration setSpelParserConfiguration(SpelParserConfiguration spelParserConfiguration) {
        this.spelParserConfiguration = spelParserConfiguration;
        return this;
    }

    public DocxStamperConfiguration setFailOnUnresolvedExpression(boolean failOnUnresolvedExpression) {
        this.failOnUnresolvedExpression = failOnUnresolvedExpression;
        return this;
    }

    public boolean isReplaceUnresolvedExpressions() {
        return this.replaceUnresolvedExpressions;
    }

    public boolean isLeaveEmptyOnExpressionError() {
        return this.leaveEmptyOnExpressionError;
    }

    public String getUnresolvedExpressionsDefaultValue() {
        return this.unresolvedExpressionsDefaultValue;
    }

    public String getLineBreakPlaceholder() {
        return this.lineBreakPlaceholder;
    }

    public EvaluationContextConfigurer getEvaluationContextConfigurer() {
        return this.evaluationContextConfigurer;
    }

    public SpelParserConfiguration getSpelParserConfiguration() {
        return this.spelParserConfiguration;
    }

    public Map<Class<?>, Object> getExpressionFunctions() {
        return this.expressionFunctions;
    }

    public Map<Class<?>, ITypeResolver<?>> getTypeResolvers() {
        return this.typeResolvers;
    }

    public ITypeResolver<Object> getDefaultTypeResolver() {
        return this.defaultTypeResolver;
    }

    public Map<Class<?>, CommentProcessorBuilder> getCommentProcessors() {
        return this.commentProcessors;
    }

    public boolean isReplaceNullValues() {
        return this.replaceNullValues;
    }

    public String getNullValuesDefault() {
        return this.nullValuesDefault;
    }

    public List<PreProcessor> getPreprocessors() {
        return this.preprocessors;
    }
}

