/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.api.typeresolver;

import java.util.HashMap;
import java.util.Map;
import org.wickedsource.docxstamper.api.typeresolver.ITypeResolver;

public class TypeResolverRegistry {
    private final Map<Class<?>, ITypeResolver<?>> typeResolversByType = new HashMap();
    private final ITypeResolver<Object> defaultResolver;

    public TypeResolverRegistry(ITypeResolver<Object> defaultResolver) {
        this.defaultResolver = defaultResolver;
    }

    public <T> void registerTypeResolver(Class<T> resolvedType, ITypeResolver<T> resolver) {
        this.typeResolversByType.put(resolvedType, resolver);
    }

    public <T> ITypeResolver<T> getResolverForType(Class<T> type) {
        return this.typeResolversByType.containsKey(type) ? this.typeResolversByType.get(type) : this.defaultResolver;
    }

    public ITypeResolver<Object> getDefaultResolver() {
        return this.defaultResolver;
    }
}

