/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.el;

import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.wickedsource.docxstamper.el.ExpressionUtil;

public class ExpressionResolver {
    private final ExpressionParser parser;
    private final StandardEvaluationContext evaluationContext;

    public ExpressionResolver(StandardEvaluationContext standardEvaluationContext, SpelParserConfiguration spelParserConfiguration) {
        this.parser = new SpelExpressionParser(spelParserConfiguration);
        this.evaluationContext = standardEvaluationContext;
    }

    public Object resolveExpression(String expressionString, Object contextRoot) {
        if ((expressionString.startsWith("${") || expressionString.startsWith("#{")) && expressionString.endsWith("}")) {
            expressionString = ExpressionUtil.stripExpression(expressionString);
        }
        this.evaluationContext.setRootObject(contextRoot);
        return this.parser.parseExpression(expressionString).getValue((EvaluationContext)this.evaluationContext);
    }
}

