/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.el;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.lang.NonNull;
import org.wickedsource.docxstamper.api.DocxStamperException;

public class ExpressionUtil {
    private static final Pattern VARIABLE_EXPRESSION_PATTERN = Pattern.compile("\\$\\{(.*?)}");
    private static final Pattern PROCESSOR_EXPRESSION_PATTERN = Pattern.compile("#\\{(.*?)}");

    private ExpressionUtil() {
        throw new DocxStamperException("Utility classes should not be instantiated!");
    }

    public static List<String> findVariableExpressions(@NonNull String text) {
        return ExpressionUtil.findExpressions(text, VARIABLE_EXPRESSION_PATTERN);
    }

    private static List<String> findExpressions(@NonNull String text, Pattern pattern) {
        if (text.isEmpty()) {
            return Collections.emptyList();
        }
        Matcher matcher = pattern.matcher(text);
        int index = 0;
        ArrayList<String> matches = new ArrayList<String>();
        while (matcher.find(index)) {
            String match = matcher.group();
            matches.add(match);
            index = matcher.end();
        }
        return matches;
    }

    public static List<String> findProcessorExpressions(@NonNull String text) {
        return ExpressionUtil.findExpressions(text, PROCESSOR_EXPRESSION_PATTERN);
    }

    public static String stripExpression(String expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Cannot strip NULL expression!");
        }
        expression = expression.replaceAll("^\\$\\{", "").replaceAll("}$", "");
        expression = expression.replaceAll("^#\\{", "").replaceAll("}$", "");
        return expression;
    }
}

