/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.processor.displayif;

import java.util.ArrayList;
import java.util.List;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.P;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Tr;
import org.wickedsource.docxstamper.api.commentprocessor.ICommentProcessor;
import org.wickedsource.docxstamper.processor.BaseCommentProcessor;
import org.wickedsource.docxstamper.processor.CommentProcessingException;
import org.wickedsource.docxstamper.processor.displayif.IDisplayIfProcessor;
import org.wickedsource.docxstamper.replace.PlaceholderReplacer;
import org.wickedsource.docxstamper.util.ObjectDeleter;

public class DisplayIfProcessor
extends BaseCommentProcessor
implements IDisplayIfProcessor {
    private List<P> paragraphsToBeRemoved = new ArrayList<P>();
    private List<Tbl> tablesToBeRemoved = new ArrayList<Tbl>();
    private List<Tr> tableRowsToBeRemoved = new ArrayList<Tr>();

    private DisplayIfProcessor(PlaceholderReplacer placeholderReplacer) {
        super(placeholderReplacer);
    }

    public static ICommentProcessor newInstance(PlaceholderReplacer pr) {
        return new DisplayIfProcessor(pr);
    }

    @Override
    public void commitChanges(WordprocessingMLPackage document) {
        this.removeParagraphs();
        this.removeTables();
        this.removeTableRows();
    }

    @Override
    public void reset() {
        this.paragraphsToBeRemoved = new ArrayList<P>();
        this.tablesToBeRemoved = new ArrayList<Tbl>();
        this.tableRowsToBeRemoved = new ArrayList<Tr>();
    }

    private void removeParagraphs() {
        for (P p : this.paragraphsToBeRemoved) {
            ObjectDeleter.deleteParagraph(p);
        }
    }

    private void removeTables() {
        for (Tbl table : this.tablesToBeRemoved) {
            ObjectDeleter.deleteTable(table);
        }
    }

    private void removeTableRows() {
        for (Tr row : this.tableRowsToBeRemoved) {
            ObjectDeleter.deleteTableRow(row);
        }
    }

    @Override
    public void displayParagraphIf(Boolean condition) {
        if (Boolean.TRUE.equals(condition)) {
            return;
        }
        this.paragraphsToBeRemoved.add(this.getParagraph());
    }

    @Override
    public void displayParagraphIfPresent(Object condition) {
        this.displayParagraphIf(condition != null);
    }

    @Override
    public void displayTableIf(Boolean condition) {
        Tr tr;
        Tc tc;
        if (Boolean.TRUE.equals(condition)) {
            return;
        }
        P p = this.getParagraph();
        Object object = p.getParent();
        if (!(object instanceof Tc && (object = (tc = (Tc)object).getParent()) instanceof Tr && (object = (tr = (Tr)object).getParent()) instanceof Tbl)) {
            throw new CommentProcessingException("Paragraph is not within a table!", p);
        }
        Tbl tbl = (Tbl)object;
        this.tablesToBeRemoved.add(tbl);
    }

    @Override
    public void displayTableRowIf(Boolean condition) {
        Tc tc;
        if (Boolean.TRUE.equals(condition)) {
            return;
        }
        P p = this.getParagraph();
        Object object = p.getParent();
        if (!(object instanceof Tc) || !((object = (tc = (Tc)object).getParent()) instanceof Tr)) {
            throw new CommentProcessingException("Paragraph is not within a table!", p);
        }
        Tr tr = (Tr)object;
        this.tableRowsToBeRemoved.add(tr);
    }
}

