/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.processor.repeat;

import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.CommentRangeEnd;
import org.docx4j.wml.CommentRangeStart;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.P;
import org.docx4j.wml.SectPr;
import org.wickedsource.docxstamper.api.DocxStamperException;
import org.wickedsource.docxstamper.api.commentprocessor.ICommentProcessor;
import org.wickedsource.docxstamper.processor.BaseCommentProcessor;
import org.wickedsource.docxstamper.processor.repeat.IParagraphRepeatProcessor;
import org.wickedsource.docxstamper.replace.PlaceholderReplacer;
import org.wickedsource.docxstamper.util.CommentUtil;
import org.wickedsource.docxstamper.util.CommentWrapper;
import org.wickedsource.docxstamper.util.ParagraphUtil;
import org.wickedsource.docxstamper.util.SectionUtil;

public class ParagraphRepeatProcessor
extends BaseCommentProcessor
implements IParagraphRepeatProcessor {
    private final Supplier<? extends List<? extends P>> nullSupplier;
    private Map<P, Paragraphs> pToRepeat = new HashMap<P, Paragraphs>();

    private ParagraphRepeatProcessor(PlaceholderReplacer placeholderReplacer, Supplier<? extends List<? extends P>> nullSupplier) {
        super(placeholderReplacer);
        this.nullSupplier = nullSupplier;
    }

    public static ICommentProcessor newInstance(PlaceholderReplacer pr, String nullReplacement) {
        return new ParagraphRepeatProcessor(pr, () -> Collections.singletonList(ParagraphUtil.create(nullReplacement)));
    }

    public static ICommentProcessor newInstance(PlaceholderReplacer placeholderReplacer) {
        return new ParagraphRepeatProcessor(placeholderReplacer, Collections::emptyList);
    }

    public static Deque<P> getParagraphsInsideComment(P paragraph) {
        BigInteger commentId = null;
        boolean foundEnd = false;
        ArrayDeque<P> paragraphs = new ArrayDeque<P>();
        paragraphs.add(paragraph);
        for (Object object : paragraph.getContent()) {
            CommentRangeEnd cre;
            if (object instanceof CommentRangeStart) {
                CommentRangeStart crs = (CommentRangeStart)object;
                commentId = crs.getId();
            }
            if (!(object instanceof CommentRangeEnd) || !Objects.equals(commentId, (cre = (CommentRangeEnd)object).getId())) continue;
            foundEnd = true;
        }
        if (foundEnd || commentId == null) {
            return paragraphs;
        }
        Object parent = paragraph.getParent();
        if (parent instanceof ContentAccessor) {
            ContentAccessor contentAccessor = (ContentAccessor)parent;
            int index = contentAccessor.getContent().indexOf(paragraph);
            block1: for (int i = index + 1; i < contentAccessor.getContent().size() && !foundEnd; ++i) {
                CommentRangeEnd cre;
                Object next = contentAccessor.getContent().get(i);
                if (next instanceof CommentRangeEnd && (cre = (CommentRangeEnd)next).getId().equals(commentId)) {
                    foundEnd = true;
                    continue;
                }
                if (next instanceof P) {
                    P p = (P)next;
                    paragraphs.add(p);
                }
                if (!(next instanceof ContentAccessor)) continue;
                ContentAccessor childContent = (ContentAccessor)next;
                for (Object child : childContent.getContent()) {
                    CommentRangeEnd cre2;
                    if (!(child instanceof CommentRangeEnd) || !(cre2 = (CommentRangeEnd)child).getId().equals(commentId)) continue;
                    foundEnd = true;
                    continue block1;
                }
            }
        }
        return paragraphs;
    }

    private static void restoreFirstSectionBreakIfNeeded(Paragraphs paragraphs, Deque<P> paragraphsToAdd) {
        if (paragraphs.firstParagraphSectionBreak != null) {
            P breakP = paragraphsToAdd.getLast();
            SectionUtil.applySectionBreakToParagraph(paragraphs.firstParagraphSectionBreak, breakP);
        }
    }

    @Override
    public void repeatParagraph(List<Object> objects) {
        P paragraph = this.getParagraph();
        Deque<P> paragraphs = ParagraphRepeatProcessor.getParagraphsInsideComment(paragraph);
        Paragraphs toRepeat = new Paragraphs();
        toRepeat.commentWrapper = this.getCurrentCommentWrapper();
        toRepeat.data = new ArrayDeque<Object>(objects);
        toRepeat.paragraphs = paragraphs;
        toRepeat.sectionBreakBefore = SectionUtil.getPreviousSectionBreakIfPresent(paragraph, (ContentAccessor)paragraph.getParent());
        toRepeat.firstParagraphSectionBreak = SectionUtil.getParagraphSectionBreak(paragraph);
        toRepeat.hasOddSectionBreaks = SectionUtil.isOddNumberOfSectionBreaks(new ArrayList<P>(toRepeat.paragraphs));
        if (paragraph.getPPr() != null && paragraph.getPPr().getSectPr() != null) {
            paragraph.getPPr().setSectPr(null);
        }
        this.pToRepeat.put(paragraph, toRepeat);
    }

    private Deque<P> generateParagraphsToAdd(WordprocessingMLPackage document, Paragraphs paragraphs, Deque<Object> expressionContexts) {
        ArrayDeque<P> paragraphsToAdd = new ArrayDeque<P>();
        Object lastExpressionContext = expressionContexts.peekLast();
        P lastParagraph = paragraphs.paragraphs.peekLast();
        for (Object expressionContext : expressionContexts) {
            for (P paragraphToClone : paragraphs.paragraphs) {
                P pClone = (P)XmlUtils.deepCopy((Object)paragraphToClone);
                if (paragraphs.sectionBreakBefore != null && paragraphs.hasOddSectionBreaks && expressionContext != lastExpressionContext && paragraphToClone == lastParagraph) {
                    SectionUtil.applySectionBreakToParagraph(paragraphs.sectionBreakBefore, pClone);
                }
                CommentUtil.deleteCommentFromElement(pClone.getContent(), paragraphs.commentWrapper.getComment().getId());
                this.placeholderReplacer.resolveExpressionsForParagraph(pClone, expressionContext, document);
                paragraphsToAdd.add(pClone);
            }
        }
        return paragraphsToAdd;
    }

    @Override
    public void commitChanges(WordprocessingMLPackage document) {
        for (Map.Entry<P, Paragraphs> entry : this.pToRepeat.entrySet()) {
            P currentP = entry.getKey();
            ContentAccessor parent = (ContentAccessor)currentP.getParent();
            List parentContent = parent.getContent();
            int index = parentContent.indexOf(currentP);
            if (index < 0) {
                throw new DocxStamperException("Impossible");
            }
            Paragraphs paragraphsToRepeat = entry.getValue();
            Deque<Object> expressionContexts = Objects.requireNonNull(paragraphsToRepeat).data;
            ArrayDeque<P> collection = expressionContexts == null ? new ArrayDeque(this.nullSupplier.get()) : this.generateParagraphsToAdd(document, paragraphsToRepeat, expressionContexts);
            ParagraphRepeatProcessor.restoreFirstSectionBreakIfNeeded(paragraphsToRepeat, collection);
            parentContent.addAll(index, collection);
            parentContent.removeAll(paragraphsToRepeat.paragraphs);
        }
    }

    @Override
    public void reset() {
        this.pToRepeat = new HashMap<P, Paragraphs>();
    }

    private static class Paragraphs {
        CommentWrapper commentWrapper;
        Deque<Object> data;
        Deque<P> paragraphs;
        boolean hasOddSectionBreaks;
        SectPr sectionBreakBefore;
        SectPr firstParagraphSectionBreak;

        private Paragraphs() {
        }
    }
}

