/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.CommentsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.Body;
import org.docx4j.wml.CommentRangeEnd;
import org.docx4j.wml.CommentRangeStart;
import org.docx4j.wml.Comments;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.R;
import org.docx4j.wml.Tc;
import org.jvnet.jaxb2_commons.ppp.Child;
import org.wickedsource.docxstamper.api.DocxStamperException;
import org.wickedsource.docxstamper.util.CommentUtil;
import org.wickedsource.docxstamper.util.DocumentUtil;

public class CommentWrapper {
    private final Set<CommentWrapper> children = new HashSet<CommentWrapper>();
    private Comments.Comment comment;
    private CommentRangeStart commentRangeStart;
    private CommentRangeEnd commentRangeEnd;
    private R.CommentReference commentReference;

    void setComment(Comments.Comment comment) {
        this.comment = comment;
    }

    void setCommentRangeStart(CommentRangeStart commentRangeStart) {
        this.commentRangeStart = commentRangeStart;
    }

    void setCommentRangeEnd(CommentRangeEnd commentRangeEnd) {
        this.commentRangeEnd = commentRangeEnd;
    }

    void setCommentReference(R.CommentReference commentReference) {
        this.commentReference = commentReference;
    }

    void setChildren(Set<CommentWrapper> children) {
        this.children.addAll(children);
    }

    public ContentAccessor getParent() {
        return this.findGreatestCommonParent(this.getCommentRangeEnd().getParent(), (ContentAccessor)this.getCommentRangeStart().getParent());
    }

    private ContentAccessor findGreatestCommonParent(Object end, ContentAccessor start) {
        if (this.depthElementSearch(end, start)) {
            return this.findInsertableParent(start);
        }
        return this.findGreatestCommonParent(end, (ContentAccessor)((Child)start).getParent());
    }

    private boolean depthElementSearch(Object searchTarget, Object content) {
        if (searchTarget.equals(content = XmlUtils.unwrap((Object)content))) {
            return true;
        }
        if (content instanceof ContentAccessor) {
            ContentAccessor contentAccessor = (ContentAccessor)content;
            for (Object object : contentAccessor.getContent()) {
                Object unwrappedObject = XmlUtils.unwrap(object);
                if (!searchTarget.equals(unwrappedObject) && !this.depthElementSearch(searchTarget, unwrappedObject)) continue;
                return true;
            }
        }
        return false;
    }

    private ContentAccessor findInsertableParent(ContentAccessor searchFrom) {
        if (!(searchFrom instanceof Tc) && !(searchFrom instanceof Body)) {
            return this.findInsertableParent((ContentAccessor)((Child)searchFrom).getParent());
        }
        return searchFrom;
    }

    public List<Object> getRepeatElements() {
        ArrayList<Object> repeatElements = new ArrayList<Object>();
        boolean startFound = false;
        for (Object element : this.getParent().getContent()) {
            if (!startFound && this.depthElementSearch(this.getCommentRangeStart(), element)) {
                startFound = true;
            }
            if (!startFound) continue;
            repeatElements.add(element);
            if (!this.depthElementSearch(this.getCommentRangeEnd(), element)) continue;
            break;
        }
        return repeatElements;
    }

    private void removeCommentAnchorsFromFinalElements(List<Object> finalRepeatElements) {
        ContentAccessor fakeBody = () -> finalRepeatElements;
        CommentUtil.deleteCommentFromElement(fakeBody.getContent(), this.getComment().getId());
    }

    private void extractedSubComments(List<Comments.Comment> commentList, Set<CommentWrapper> commentWrapperChildren) {
        ArrayDeque<CommentWrapper> q = new ArrayDeque<CommentWrapper>(commentWrapperChildren);
        while (!q.isEmpty()) {
            CommentWrapper element = (CommentWrapper)q.remove();
            commentList.add(element.getComment());
            if (element.getChildren() == null) continue;
            q.addAll(element.getChildren());
        }
    }

    public WordprocessingMLPackage getSubTemplate(WordprocessingMLPackage document) throws Exception {
        List<Object> repeatElements = this.getRepeatElements();
        WordprocessingMLPackage subDocument = WordprocessingMLPackage.createPackage();
        MainDocumentPart subDocumentMainDocumentPart = subDocument.getMainDocumentPart();
        CommentsPart commentsPart = new CommentsPart();
        subDocumentMainDocumentPart.addTargetPart((Part)commentsPart);
        List<Object> finalRepeatElements = repeatElements.stream().map(XmlUtils::deepCopy).collect(Collectors.toList());
        this.removeCommentAnchorsFromFinalElements(finalRepeatElements);
        subDocumentMainDocumentPart.getContent().addAll(finalRepeatElements);
        ObjectFactory wmlObjectFactory = Context.getWmlObjectFactory();
        Body fakeBody = wmlObjectFactory.createBody();
        fakeBody.getContent().addAll(repeatElements);
        DocumentUtil.walkObjectsAndImportImages((ContentAccessor)fakeBody, document, subDocument);
        Comments comments = wmlObjectFactory.createComments();
        this.extractedSubComments(comments.getComment(), this.getChildren());
        commentsPart.setContents((Object)comments);
        return subDocument;
    }

    public WordprocessingMLPackage tryBuildingSubtemplate(WordprocessingMLPackage document) {
        try {
            return this.getSubTemplate(document);
        }
        catch (Exception e) {
            throw new DocxStamperException(e);
        }
    }

    public CommentRangeEnd getCommentRangeEnd() {
        return this.commentRangeEnd;
    }

    public CommentRangeStart getCommentRangeStart() {
        return this.commentRangeStart;
    }

    public R.CommentReference getCommentReference() {
        return this.commentReference;
    }

    public Set<CommentWrapper> getChildren() {
        return this.children;
    }

    public Comments.Comment getComment() {
        return this.comment;
    }
}

