/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.util;

import jakarta.xml.bind.JAXBElement;
import java.util.Objects;
import org.docx4j.jaxb.Context;
import org.docx4j.model.styles.StyleUtil;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.ParaRPr;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Text;
import org.wickedsource.docxstamper.api.DocxStamperException;

public class RunUtil {
    private static final String PRESERVE = "preserve";
    private static final ObjectFactory factory = Context.getWmlObjectFactory();

    private RunUtil() {
        throw new DocxStamperException("Utility class shouldn't be instantiated");
    }

    public static String getText(R run) {
        StringBuilder result = new StringBuilder();
        for (Object content : run.getContent()) {
            if (content instanceof JAXBElement) {
                result.append(RunUtil.getText((JAXBElement)content));
                continue;
            }
            if (!(content instanceof Text)) continue;
            Text text = (Text)content;
            result.append(RunUtil.getText(text));
        }
        return result.toString();
    }

    private static CharSequence getText(JAXBElement<?> content) {
        Object elementValue = content.getValue();
        if (elementValue instanceof Text) {
            Text text = (Text)elementValue;
            return RunUtil.getText(text);
        }
        if (elementValue instanceof R.Tab) {
            return "\t";
        }
        return "";
    }

    private static CharSequence getText(Text text) {
        String value = text.getValue();
        String space = text.getSpace();
        return Objects.equals(space, PRESERVE) ? value : value.trim();
    }

    public static R create(Object content) {
        R run = factory.createR();
        run.getContent().add(content);
        return run;
    }

    public static R create(String text, P parentParagraph) {
        R run = RunUtil.create(text);
        RunUtil.applyParagraphStyle(parentParagraph, run);
        return run;
    }

    public static R create(String text) {
        R run = factory.createR();
        RunUtil.setText(run, text);
        return run;
    }

    public static void applyParagraphStyle(P p, R run) {
        if (p.getPPr() != null && p.getPPr().getRPr() != null) {
            RPr runProperties = new RPr();
            StyleUtil.apply((ParaRPr)p.getPPr().getRPr(), (RPr)runProperties);
            run.setRPr(runProperties);
        }
    }

    public static void setText(R run, String text) {
        run.getContent().clear();
        Text textObj = RunUtil.createText(text);
        run.getContent().add(textObj);
    }

    public static Text createText(String text) {
        Text textObj = factory.createText();
        textObj.setValue(text);
        textObj.setSpace(PRESERVE);
        return textObj;
    }
}

