/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.util.walk;

import org.docx4j.XmlUtils;
import org.docx4j.wml.CommentRangeEnd;
import org.docx4j.wml.CommentRangeStart;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Tr;

public abstract class DocumentWalker {
    private final ContentAccessor contentAccessor;

    protected DocumentWalker(ContentAccessor contentAccessor) {
        this.contentAccessor = contentAccessor;
    }

    public void walk() {
        for (Object contentElement : this.contentAccessor.getContent()) {
            Object unwrappedObject = XmlUtils.unwrap(contentElement);
            if (unwrappedObject instanceof P) {
                P p = (P)unwrappedObject;
                this.walkParagraph(p);
                continue;
            }
            if (unwrappedObject instanceof R) {
                R r = (R)unwrappedObject;
                this.walkRun(r);
                continue;
            }
            if (unwrappedObject instanceof Tbl) {
                Tbl table = (Tbl)unwrappedObject;
                this.walkTable(table);
                continue;
            }
            if (unwrappedObject instanceof Tr) {
                Tr row = (Tr)unwrappedObject;
                this.walkTableRow(row);
                continue;
            }
            if (unwrappedObject instanceof Tc) {
                Tc cell = (Tc)unwrappedObject;
                this.walkTableCell(cell);
                continue;
            }
            if (unwrappedObject instanceof CommentRangeStart) {
                CommentRangeStart commentRangeStart = (CommentRangeStart)unwrappedObject;
                this.onCommentRangeStart(commentRangeStart);
                continue;
            }
            if (unwrappedObject instanceof CommentRangeEnd) {
                CommentRangeEnd commentRangeEnd = (CommentRangeEnd)unwrappedObject;
                this.onCommentRangeEnd(commentRangeEnd);
                continue;
            }
            if (!(unwrappedObject instanceof R.CommentReference)) continue;
            R.CommentReference commentReference = (R.CommentReference)unwrappedObject;
            this.onCommentReference(commentReference);
        }
    }

    private void walkTable(Tbl table) {
        this.onTable(table);
        for (Object contentElement : table.getContent()) {
            Object unwrappedObject = XmlUtils.unwrap(contentElement);
            if (!(unwrappedObject instanceof Tr)) continue;
            Tr row = (Tr)unwrappedObject;
            this.walkTableRow(row);
        }
    }

    private void walkTableRow(Tr row) {
        this.onTableRow(row);
        for (Object rowContentElement : row.getContent()) {
            Object unwrappedObject = XmlUtils.unwrap(rowContentElement);
            if (!(unwrappedObject instanceof Tc)) continue;
            Tc cell = (Tc)unwrappedObject;
            this.walkTableCell(cell);
        }
    }

    private void walkTableCell(Tc cell) {
        this.onTableCell(cell);
        for (Object cellContentElement : cell.getContent()) {
            Object unwrappedObject = XmlUtils.unwrap(cellContentElement);
            if (unwrappedObject instanceof P) {
                P p = (P)cellContentElement;
                this.walkParagraph(p);
                continue;
            }
            if (unwrappedObject instanceof R) {
                R r = (R)cellContentElement;
                this.walkRun(r);
                continue;
            }
            if (unwrappedObject instanceof Tbl) {
                Tbl nestedTable = (Tbl)unwrappedObject;
                this.walkTable(nestedTable);
                continue;
            }
            if (unwrappedObject instanceof CommentRangeStart) {
                CommentRangeStart commentRangeStart = (CommentRangeStart)unwrappedObject;
                this.onCommentRangeStart(commentRangeStart);
                continue;
            }
            if (!(unwrappedObject instanceof CommentRangeEnd)) continue;
            CommentRangeEnd commentRangeEnd = (CommentRangeEnd)unwrappedObject;
            this.onCommentRangeEnd(commentRangeEnd);
        }
    }

    private void walkParagraph(P p) {
        this.onParagraph(p);
        for (Object element : p.getContent()) {
            Object unwrappedObject = XmlUtils.unwrap(element);
            if (unwrappedObject instanceof R) {
                R r = (R)unwrappedObject;
                this.walkRun(r);
                continue;
            }
            if (unwrappedObject instanceof CommentRangeStart) {
                CommentRangeStart commentRangeStart = (CommentRangeStart)unwrappedObject;
                this.onCommentRangeStart(commentRangeStart);
                continue;
            }
            if (!(unwrappedObject instanceof CommentRangeEnd)) continue;
            CommentRangeEnd commentRangeEnd = (CommentRangeEnd)unwrappedObject;
            this.onCommentRangeEnd(commentRangeEnd);
        }
    }

    private void walkRun(R r) {
        this.onRun(r);
        for (Object element : r.getContent()) {
            Object unwrappedObject = XmlUtils.unwrap(element);
            if (!(unwrappedObject instanceof R.CommentReference)) continue;
            R.CommentReference commentReference = (R.CommentReference)unwrappedObject;
            this.onCommentReference(commentReference);
        }
    }

    protected abstract void onRun(R var1);

    protected abstract void onParagraph(P var1);

    protected abstract void onTable(Tbl var1);

    protected abstract void onTableCell(Tc var1);

    protected abstract void onTableRow(Tr var1);

    protected abstract void onCommentRangeStart(CommentRangeStart var1);

    protected abstract void onCommentRangeEnd(CommentRangeEnd var1);

    protected abstract void onCommentReference(R.CommentReference var1);
}

