/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.el;

import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.wickedsource.docxstamper.el.Matcher;

public class ExpressionResolver {
    private static final Matcher DEFAULT_MATCHER = new Matcher("${", "}");
    private static final Matcher SECONDARY_MATCHER = new Matcher("#{", "}");
    private final ExpressionParser parser;
    private final StandardEvaluationContext evaluationContext;

    public ExpressionResolver(StandardEvaluationContext standardEvaluationContext, SpelParserConfiguration spelParserConfiguration) {
        this.parser = new SpelExpressionParser(spelParserConfiguration);
        this.evaluationContext = standardEvaluationContext;
    }

    public static String cleanExpression(String expression) {
        if (DEFAULT_MATCHER.match(expression)) {
            return DEFAULT_MATCHER.strip(expression);
        }
        if (SECONDARY_MATCHER.match(expression)) {
            return SECONDARY_MATCHER.strip(expression);
        }
        return expression;
    }

    public Object resolveExpression(String expression, Object contextRoot) {
        expression = ExpressionResolver.cleanExpression(expression);
        this.evaluationContext.setRootObject(contextRoot);
        return this.parser.parseExpression(expression).getValue((EvaluationContext)this.evaluationContext);
    }
}

