/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.processor;

import java.util.Objects;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.wickedsource.docxstamper.api.commentprocessor.ICommentProcessor;
import org.wickedsource.docxstamper.replace.PlaceholderReplacer;
import org.wickedsource.docxstamper.util.CommentWrapper;

public abstract class BaseCommentProcessor
implements ICommentProcessor {
    protected final PlaceholderReplacer placeholderReplacer;
    private P paragraph;
    private R currentRun;
    private CommentWrapper currentCommentWrapper;
    private WordprocessingMLPackage document;

    protected BaseCommentProcessor(PlaceholderReplacer placeholderReplacer) {
        this.placeholderReplacer = placeholderReplacer;
    }

    @Override
    public void setCurrentRun(R run) {
        this.currentRun = run;
    }

    @Override
    public void setParagraph(P paragraph) {
        this.paragraph = paragraph;
    }

    @Override
    public void setCurrentCommentWrapper(CommentWrapper currentCommentWrapper) {
        Objects.requireNonNull(currentCommentWrapper.getCommentRangeStart());
        Objects.requireNonNull(currentCommentWrapper.getCommentRangeEnd());
        this.currentCommentWrapper = currentCommentWrapper;
    }

    @Override
    @Deprecated(since="1.6.5", forRemoval=true)
    public void setDocument(WordprocessingMLPackage document) {
        this.document = document;
    }

    public CommentWrapper getCurrentCommentWrapper() {
        return this.currentCommentWrapper;
    }

    public P getParagraph() {
        return this.paragraph;
    }

    public R getCurrentRun() {
        return this.currentRun;
    }

    @Deprecated(since="1.6.5", forRemoval=true)
    public WordprocessingMLPackage getDocument() {
        return this.document;
    }
}

