/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.processor;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.Comments;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelParseException;
import org.springframework.lang.NonNull;
import org.wickedsource.docxstamper.api.DocxStamperException;
import org.wickedsource.docxstamper.api.UnresolvedExpressionException;
import org.wickedsource.docxstamper.api.commentprocessor.ICommentProcessor;
import org.wickedsource.docxstamper.el.ExpressionResolver;
import org.wickedsource.docxstamper.el.ExpressionUtil;
import org.wickedsource.docxstamper.replace.PlaceholderReplacer;
import org.wickedsource.docxstamper.util.CommentUtil;
import org.wickedsource.docxstamper.util.CommentWrapper;
import org.wickedsource.docxstamper.util.ParagraphWrapper;
import org.wickedsource.docxstamper.util.walk.BaseCoordinatesWalker;

public class CommentProcessorRegistry {
    private final Logger logger = LoggerFactory.getLogger(CommentProcessorRegistry.class);
    private final PlaceholderReplacer placeholderReplacer;
    private final Map<Class<?>, Object> commentProcessors;
    private final boolean failOnUnresolvedExpression;
    private final ExpressionResolver expressionResolver;

    public CommentProcessorRegistry(PlaceholderReplacer placeholderReplacer, ExpressionResolver expressionResolver, Map<Class<?>, Object> commentProcessors, boolean failOnUnresolvedExpression) {
        this.placeholderReplacer = placeholderReplacer;
        this.expressionResolver = expressionResolver;
        this.commentProcessors = commentProcessors;
        this.failOnUnresolvedExpression = failOnUnresolvedExpression;
    }

    public <T> void runProcessors(final WordprocessingMLPackage document, final T expressionContext) {
        final Map<BigInteger, CommentWrapper> comments = CommentUtil.getComments(document);
        final ArrayList proceedComments = new ArrayList();
        new BaseCoordinatesWalker(){

            @Override
            protected void onRun(R run, P paragraph) {
                CommentProcessorRegistry.this.runProcessorsOnRunComment(document, comments, expressionContext, paragraph, run).ifPresent(proceedComments::add);
            }

            @Override
            protected void onParagraph(P paragraph) {
                CommentProcessorRegistry.this.runProcessorsOnParagraphComment(document, comments, expressionContext, paragraph).ifPresent(proceedComments::add);
                CommentProcessorRegistry.this.runProcessorsOnInlineContent(expressionContext, paragraph);
            }
        }.walk(document);
        for (Object processor : this.commentProcessors.values()) {
            ((ICommentProcessor)processor).commitChanges(document);
        }
        for (CommentWrapper commentWrapper : proceedComments) {
            CommentUtil.deleteComment(commentWrapper);
        }
    }

    private <T> Optional<CommentWrapper> runProcessorsOnRunComment(WordprocessingMLPackage document, Map<BigInteger, CommentWrapper> comments, T expressionContext, P paragraph, R run) {
        Optional<Comments.Comment> comment = CommentUtil.getCommentAround(run, document);
        return comment.flatMap(c -> this.runCommentProcessors(comments, expressionContext, (Comments.Comment)c, paragraph, run, document));
    }

    private <T> Optional<CommentWrapper> runProcessorsOnParagraphComment(WordprocessingMLPackage document, Map<BigInteger, CommentWrapper> comments, T expressionContext, P paragraph) {
        return CommentUtil.getCommentFor((ContentAccessor)paragraph, document).flatMap(c -> this.runCommentProcessors(comments, expressionContext, (Comments.Comment)c, paragraph, null, document));
    }

    private <T> void runProcessorsOnInlineContent(T expressionContext, P paragraph) {
        ParagraphWrapper paragraphWrapper = new ParagraphWrapper(paragraph);
        List<String> processorExpressions = ExpressionUtil.findProcessorExpressions(paragraphWrapper.getText());
        for (String processorExpression : processorExpressions) {
            String strippedExpression = ExpressionResolver.cleanExpression(processorExpression);
            for (Object processor : this.commentProcessors.values()) {
                ((ICommentProcessor)processor).setParagraph(paragraph);
            }
            try {
                this.expressionResolver.resolveExpression(strippedExpression, expressionContext);
                this.placeholderReplacer.replace(paragraphWrapper, processorExpression, "");
                this.logger.debug("Processor expression '{}' has been successfully processed by a comment processor.", (Object)processorExpression);
            }
            catch (SpelEvaluationException | SpelParseException e) {
                String msg = "Expression '%s' failed since no processor solves it".formatted(strippedExpression);
                if (this.failOnUnresolvedExpression) {
                    throw new DocxStamperException(msg, e);
                }
                this.logger.warn(msg, e);
            }
        }
    }

    private <T> Optional<CommentWrapper> runCommentProcessors(Map<BigInteger, CommentWrapper> comments, T expressionContext, @NonNull Comments.Comment comment, P paragraph, R run, WordprocessingMLPackage document) {
        CommentWrapper commentWrapper = comments.get(comment.getId());
        if (Objects.isNull(commentWrapper)) {
            return Optional.empty();
        }
        String commentString = CommentUtil.getCommentString(comment);
        for (Object processor : this.commentProcessors.values()) {
            ((ICommentProcessor)processor).setParagraph(paragraph);
            ((ICommentProcessor)processor).setCurrentRun(run);
            ((ICommentProcessor)processor).setCurrentCommentWrapper(commentWrapper);
            ((ICommentProcessor)processor).setDocument(document);
        }
        try {
            this.expressionResolver.resolveExpression(commentString, expressionContext);
            comments.remove(comment.getId());
            this.logger.debug("Comment {} has been successfully processed by a comment processor.", (Object)commentString);
            return Optional.of(commentWrapper);
        }
        catch (SpelEvaluationException | SpelParseException e) {
            if (this.failOnUnresolvedExpression) {
                throw new UnresolvedExpressionException(commentString, e);
            }
            this.logger.warn(String.format("Skipping comment expression '%s' because it can not be resolved by any comment processor. Reason: %s. Set log level to TRACE to view Stacktrace.", commentString, e.getMessage()));
            this.logger.trace("Reason for skipping comment: ", e);
            return Optional.empty();
        }
    }

    public void reset() {
        for (Object processor : this.commentProcessors.values()) {
            ((ICommentProcessor)processor).reset();
        }
    }
}

