/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.processor.repeat;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.SectPr;
import org.jvnet.jaxb2_commons.ppp.Child;
import org.wickedsource.docxstamper.api.DocxStamperException;
import org.wickedsource.docxstamper.api.commentprocessor.ICommentProcessor;
import org.wickedsource.docxstamper.processor.BaseCommentProcessor;
import org.wickedsource.docxstamper.processor.repeat.IRepeatDocPartProcessor;
import org.wickedsource.docxstamper.replace.PlaceholderReplacer;
import org.wickedsource.docxstamper.util.CommentWrapper;
import org.wickedsource.docxstamper.util.DocumentUtil;
import org.wickedsource.docxstamper.util.ParagraphUtil;
import org.wickedsource.docxstamper.util.SectionUtil;
import pro.verron.docxstamper.OpcStamper;
import pro.verron.docxstamper.utils.ProcessorExceptionHandler;

public class RepeatDocPartProcessor
extends BaseCommentProcessor
implements IRepeatDocPartProcessor {
    private static final ThreadFactory threadFactory = Executors.defaultThreadFactory();
    private static final ObjectFactory objectFactory = Context.getWmlObjectFactory();
    private final OpcStamper<WordprocessingMLPackage> stamper;
    private final Map<CommentWrapper, List<Object>> contexts = new HashMap<CommentWrapper, List<Object>>();
    private final Supplier<? extends List<?>> nullSupplier;

    private RepeatDocPartProcessor(PlaceholderReplacer placeholderReplacer, OpcStamper<WordprocessingMLPackage> stamper, Supplier<? extends List<?>> nullSupplier) {
        super(placeholderReplacer);
        this.stamper = stamper;
        this.nullSupplier = nullSupplier;
    }

    public static ICommentProcessor newInstance(PlaceholderReplacer pr, OpcStamper<WordprocessingMLPackage> stamper, String nullReplacementValue) {
        Supplier<List> nullSupplier = () -> Collections.singletonList(ParagraphUtil.create(nullReplacementValue));
        return new RepeatDocPartProcessor(pr, stamper, nullSupplier);
    }

    public static ICommentProcessor newInstance(PlaceholderReplacer pr, OpcStamper<WordprocessingMLPackage> stamper) {
        return new RepeatDocPartProcessor(pr, stamper, Collections::emptyList);
    }

    private static void recursivelyReplaceImages(ContentAccessor r, Map<R, R> replacements) {
        ArrayDeque<ContentAccessor> q = new ArrayDeque<ContentAccessor>();
        q.add(r);
        while (!q.isEmpty()) {
            Child child;
            Object object;
            ContentAccessor run = (ContentAccessor)q.remove();
            if (replacements.containsKey(run) && run instanceof Child && (object = (child = (Child)run).getParent()) instanceof ContentAccessor) {
                ContentAccessor parent = (ContentAccessor)object;
                List parentContent = parent.getContent();
                parentContent.add(parentContent.indexOf(run), replacements.get(run));
                parentContent.remove(run);
                continue;
            }
            q.addAll(run.getContent().stream().filter(ContentAccessor.class::isInstance).map(ContentAccessor.class::cast).toList());
        }
    }

    private static List<Object> documentAsInsertableElements(WordprocessingMLPackage subDocument, boolean oddNumberOfBreaks, SectPr previousSectionBreak) {
        ArrayList<Object> inserts = new ArrayList<Object>(DocumentUtil.allElements(subDocument));
        if (oddNumberOfBreaks && previousSectionBreak != null) {
            Object object = DocumentUtil.lastElement(subDocument);
            if (object instanceof P) {
                P p = (P)object;
                SectionUtil.applySectionBreakToParagraph(previousSectionBreak, p);
            } else {
                P p = objectFactory.createP();
                SectionUtil.applySectionBreakToParagraph(previousSectionBreak, p);
                inserts.add(p);
            }
        }
        return inserts;
    }

    private static void setParentIfPossible(Object object, ContentAccessor parent) {
        if (object instanceof Child) {
            Child child = (Child)object;
            child.setParent((Object)parent);
        }
    }

    @Override
    public void repeatDocPart(List<Object> contexts) {
        CommentWrapper currentCommentWrapper;
        List<Object> repeatElements;
        if (contexts == null) {
            contexts = Collections.emptyList();
        }
        if (!(repeatElements = (currentCommentWrapper = this.getCurrentCommentWrapper()).getRepeatElements()).isEmpty()) {
            this.contexts.put(currentCommentWrapper, contexts);
        }
    }

    private List<Object> stampSubDocuments(WordprocessingMLPackage document, List<Object> expressionContexts, ContentAccessor gcp, WordprocessingMLPackage subTemplate, SectPr previousSectionBreak, boolean oddNumberOfBreaks) {
        Deque<WordprocessingMLPackage> subDocuments = this.stampSubDocuments(expressionContexts, subTemplate);
        Map<R, R> replacements = subDocuments.stream().map(p -> DocumentUtil.walkObjectsAndImportImages(p, document)).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ArrayList<Object> changes = new ArrayList<Object>();
        for (WordprocessingMLPackage subDocument : subDocuments) {
            List<Object> os = RepeatDocPartProcessor.documentAsInsertableElements(subDocument, oddNumberOfBreaks, previousSectionBreak);
            os.stream().filter(ContentAccessor.class::isInstance).map(ContentAccessor.class::cast).forEach(o -> RepeatDocPartProcessor.recursivelyReplaceImages(o, replacements));
            os.forEach(c -> RepeatDocPartProcessor.setParentIfPossible(c, gcp));
            changes.addAll(os);
        }
        return changes;
    }

    private Deque<WordprocessingMLPackage> stampSubDocuments(List<Object> subContexts, WordprocessingMLPackage subTemplate) {
        ArrayDeque<WordprocessingMLPackage> subDocuments = new ArrayDeque<WordprocessingMLPackage>();
        for (Object subContext : subContexts) {
            WordprocessingMLPackage templateCopy = this.outputWord(os -> this.copy(subTemplate, (OutputStream)os));
            WordprocessingMLPackage subDocument = this.outputWord(os -> this.stamp(subContext, templateCopy, (OutputStream)os));
            subDocuments.add(subDocument);
        }
        return subDocuments;
    }

    @Override
    public void commitChanges(WordprocessingMLPackage document) {
        for (Map.Entry<CommentWrapper, List<Object>> entry : this.contexts.entrySet()) {
            CommentWrapper commentWrapper = entry.getKey();
            List<Object> expressionContexts = entry.getValue();
            ContentAccessor gcp = Objects.requireNonNull(commentWrapper.getParent());
            List<Object> repeatElements = commentWrapper.getRepeatElements();
            WordprocessingMLPackage subTemplate = commentWrapper.tryBuildingSubtemplate(document);
            SectPr previousSectionBreak = SectionUtil.getPreviousSectionBreakIfPresent(repeatElements.get(0), gcp);
            boolean oddNumberOfBreaks = SectionUtil.isOddNumberOfSectionBreaks(repeatElements);
            List<?> changes = expressionContexts == null ? this.nullSupplier.get() : this.stampSubDocuments(document, expressionContexts, gcp, subTemplate, previousSectionBreak, oddNumberOfBreaks);
            List gcpContent = gcp.getContent();
            int index = gcpContent.indexOf(repeatElements.get(0));
            gcpContent.addAll(index, changes);
            gcpContent.removeAll(repeatElements);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private WordprocessingMLPackage outputWord(Consumer<OutputStream> outputter) {
        ProcessorExceptionHandler exceptionHandler = new ProcessorExceptionHandler();
        try (PipedOutputStream os = new PipedOutputStream();){
            WordprocessingMLPackage wordprocessingMLPackage;
            try (PipedInputStream is = new PipedInputStream(os);){
                exceptionHandler.onException(is::close);
                exceptionHandler.onException(os::close);
                Thread thread = threadFactory.newThread(() -> outputter.accept(os));
                thread.setUncaughtExceptionHandler(exceptionHandler);
                thread.start();
                WordprocessingMLPackage wordprocessingMLPackage2 = WordprocessingMLPackage.load((InputStream)is);
                thread.join();
                wordprocessingMLPackage = wordprocessingMLPackage2;
            }
            return wordprocessingMLPackage;
        }
        catch (IOException | InterruptedException | Docx4JException e) {
            DocxStamperException exception = new DocxStamperException(e);
            exceptionHandler.exception().ifPresent(exception::addSuppressed);
            throw exception;
        }
    }

    private void copy(WordprocessingMLPackage aPackage, OutputStream outputStream) {
        try {
            aPackage.save(outputStream);
        }
        catch (Docx4JException e) {
            throw new DocxStamperException(e);
        }
    }

    private void stamp(Object context, WordprocessingMLPackage template, OutputStream outputStream) {
        this.stamper.stamp(template, context, outputStream);
    }

    @Override
    public void reset() {
        this.contexts.clear();
    }
}

