/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.processor.repeat;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.Comments;
import org.docx4j.wml.P;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Tr;
import org.wickedsource.docxstamper.api.commentprocessor.ICommentProcessor;
import org.wickedsource.docxstamper.processor.BaseCommentProcessor;
import org.wickedsource.docxstamper.processor.CommentProcessingException;
import org.wickedsource.docxstamper.processor.repeat.IRepeatProcessor;
import org.wickedsource.docxstamper.processor.repeat.ParagraphResolverDocumentWalker;
import org.wickedsource.docxstamper.replace.PlaceholderReplacer;
import org.wickedsource.docxstamper.util.CommentUtil;
import org.wickedsource.docxstamper.util.CommentWrapper;

public class RepeatProcessor
extends BaseCommentProcessor
implements IRepeatProcessor {
    private final BiFunction<WordprocessingMLPackage, Tr, List<Tr>> nullSupplier;
    private Map<Tr, List<Object>> tableRowsToRepeat = new HashMap<Tr, List<Object>>();
    private Map<Tr, CommentWrapper> tableRowsCommentsToRemove = new HashMap<Tr, CommentWrapper>();

    private RepeatProcessor(PlaceholderReplacer placeholderReplacer, BiFunction<WordprocessingMLPackage, Tr, List<Tr>> nullSupplier1) {
        super(placeholderReplacer);
        this.nullSupplier = nullSupplier1;
    }

    public static ICommentProcessor newInstanceWithNullReplacement(PlaceholderReplacer pr) {
        return new RepeatProcessor(pr, (document, row) -> RepeatProcessor.stampEmptyContext(pr, document, row));
    }

    public static List<Tr> stampEmptyContext(PlaceholderReplacer pr, WordprocessingMLPackage document, Tr row1) {
        Tr rowClone = (Tr)XmlUtils.deepCopy((Object)row1);
        Object emptyContext = new Object();
        new ParagraphResolverDocumentWalker(rowClone, emptyContext, document, pr).walk();
        return List.of(rowClone);
    }

    public static ICommentProcessor newInstance(PlaceholderReplacer pr) {
        return new RepeatProcessor(pr, (document, row) -> Collections.emptyList());
    }

    @Override
    public void commitChanges(WordprocessingMLPackage document) {
        this.repeatRows(document);
    }

    @Override
    public void reset() {
        this.tableRowsToRepeat = new HashMap<Tr, List<Object>>();
        this.tableRowsCommentsToRemove = new HashMap<Tr, CommentWrapper>();
    }

    private void repeatRows(WordprocessingMLPackage document) {
        for (Map.Entry<Tr, List<Object>> entry : this.tableRowsToRepeat.entrySet()) {
            List<Object> changes;
            Tr row = entry.getKey();
            List<Object> expressionContexts = entry.getValue();
            Tbl table = (Tbl)XmlUtils.unwrap((Object)row.getParent());
            int index = table.getContent().indexOf(row);
            if (expressionContexts == null) {
                changes = this.nullSupplier.apply(document, row);
            } else {
                changes = new ArrayList();
                for (Object expressionContext : expressionContexts) {
                    Tr rowClone = (Tr)XmlUtils.deepCopy((Object)row);
                    CommentWrapper commentWrapper = Objects.requireNonNull(this.tableRowsCommentsToRemove.get(row));
                    Comments.Comment comment = Objects.requireNonNull(commentWrapper.getComment());
                    BigInteger commentId = comment.getId();
                    CommentUtil.deleteCommentFromElement(rowClone.getContent(), commentId);
                    new ParagraphResolverDocumentWalker(rowClone, expressionContext, document, this.placeholderReplacer).walk();
                    changes.add(rowClone);
                }
            }
            table.getContent().addAll(index + 1, changes);
            table.getContent().remove(row);
        }
    }

    @Override
    public void repeatTableRow(List<Object> objects) {
        Tc tc;
        P pCoords = this.getParagraph();
        Object object = pCoords.getParent();
        if (!(object instanceof Tc) || !((object = (tc = (Tc)object).getParent()) instanceof Tr)) {
            throw new CommentProcessingException("Paragraph is not within a table!", pCoords);
        }
        Tr tableRow = (Tr)object;
        this.tableRowsToRepeat.put(tableRow, objects);
        this.tableRowsCommentsToRemove.put(tableRow, this.getCurrentCommentWrapper());
    }
}

