/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.util;

import jakarta.xml.bind.JAXBElement;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.docx4j.TraversalUtil;
import org.docx4j.dml.Graphic;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.finders.ClassFinder;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Tr;
import org.wickedsource.docxstamper.api.DocxStamperException;
import org.wickedsource.docxstamper.replace.typeresolver.image.ImageResolver;
import org.wickedsource.docxstamper.util.DocxImageExtractor;

public class DocumentUtil {
    private DocumentUtil() {
        throw new DocxStamperException("Utility classes shouldn't be instantiated");
    }

    public static String getImageRelationshipId(Drawing drawing) {
        Graphic graphic = DocumentUtil.getInlineGraphic(drawing);
        return graphic.getGraphicData().getPic().getBlipFill().getBlip().getEmbed();
    }

    private static Graphic getInlineGraphic(Drawing drawing) {
        if (drawing.getAnchorOrInline().isEmpty()) {
            throw new DocxStamperException("Anchor or Inline is empty !");
        }
        Object anchorOrInline = drawing.getAnchorOrInline().get(0);
        if (anchorOrInline instanceof Inline) {
            Inline inline = (Inline)anchorOrInline;
            return inline.getGraphic();
        }
        throw new DocxStamperException("Don't know how to process anchor !");
    }

    public static List<P> getParagraphsFromObject(Object parentObject) {
        return DocumentUtil.streamElements(parentObject, P.class).toList();
    }

    public static <T> Stream<T> streamElements(Object object, Class<T> elementClass) {
        Stream<T> stream;
        if (object instanceof WordprocessingMLPackage) {
            WordprocessingMLPackage document = (WordprocessingMLPackage)object;
            stream = DocumentUtil.streamDocumentElements(document, elementClass);
        } else {
            stream = DocumentUtil.streamObjectElements(object, elementClass);
        }
        return stream;
    }

    private static <T> Stream<T> streamDocumentElements(WordprocessingMLPackage document, Class<T> elementClass) {
        RelationshipsPart mainParts = document.getMainDocumentPart().getRelationshipsPart();
        return Stream.of(DocumentUtil.streamElements(mainParts, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/header", elementClass), DocumentUtil.streamObjectElements(document.getMainDocumentPart(), elementClass), DocumentUtil.streamElements(mainParts, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer", elementClass)).reduce(Stream.empty(), Stream::concat);
    }

    private static <T> Stream<T> streamObjectElements(Object obj, Class<T> elementClass) {
        ClassFinder finder = new ClassFinder(elementClass);
        TraversalUtil.visit((Object)obj, (TraversalUtil.Callback)finder);
        return finder.results.stream().map(elementClass::cast);
    }

    private static <T> Stream<T> streamElements(RelationshipsPart mainParts, String namespace, Class<T> elementClass) {
        return mainParts.getRelationshipsByType(namespace).stream().map(arg_0 -> ((RelationshipsPart)mainParts).getPart(arg_0)).flatMap(part -> DocumentUtil.streamObjectElements(part, elementClass));
    }

    public static List<Tbl> getTableFromObject(Object parentObject) {
        return DocumentUtil.streamElements(parentObject, Tbl.class).toList();
    }

    public static List<Tr> getTableRowsFromObject(Object parentObject) {
        return DocumentUtil.streamElements(parentObject, Tr.class).toList();
    }

    public static List<Tc> getTableCellsFromObject(Object parentObject) {
        return DocumentUtil.streamElements(parentObject, Tc.class).toList();
    }

    public static Object lastElement(WordprocessingMLPackage subDocument) {
        return new ArrayDeque(subDocument.getMainDocumentPart().getContent()).getLast();
    }

    public static List<Object> allElements(WordprocessingMLPackage subDocument) {
        return subDocument.getMainDocumentPart().getContent();
    }

    public static Map<R, R> walkObjectsAndImportImages(WordprocessingMLPackage source, WordprocessingMLPackage target) {
        return DocumentUtil.walkObjectsAndImportImages((ContentAccessor)source.getMainDocumentPart(), source, target);
    }

    public static Map<R, R> walkObjectsAndImportImages(ContentAccessor container, WordprocessingMLPackage source, WordprocessingMLPackage target) {
        HashMap<R, R> replacements = new HashMap<R, R>();
        for (Object obj : container.getContent()) {
            ArrayDeque queue = new ArrayDeque();
            queue.add(obj);
            while (!queue.isEmpty()) {
                R currentR;
                Object currentObj = queue.remove();
                if (currentObj instanceof R && DocumentUtil.isImageRun(currentR = (R)currentObj)) {
                    DocxImageExtractor docxImageExtractor = new DocxImageExtractor(source);
                    byte[] imageData = docxImageExtractor.getRunDrawingData(currentR);
                    Integer maxWidth = docxImageExtractor.getRunDrawingMaxWidth(currentR);
                    BinaryPartAbstractImage imagePart = DocumentUtil.tryCreateImagePart(target, imageData);
                    replacements.put(currentR, ImageResolver.createRunWithImage(maxWidth, imagePart));
                    continue;
                }
                if (!(currentObj instanceof ContentAccessor)) continue;
                ContentAccessor contentAccessor = (ContentAccessor)currentObj;
                queue.addAll(contentAccessor.getContent());
            }
        }
        return replacements;
    }

    private static boolean isImageRun(R run) {
        return run.getContent().stream().filter(JAXBElement.class::isInstance).map(JAXBElement.class::cast).map(JAXBElement::getValue).anyMatch(Drawing.class::isInstance);
    }

    private static BinaryPartAbstractImage tryCreateImagePart(WordprocessingMLPackage destDocument, byte[] imageData) {
        try {
            return BinaryPartAbstractImage.createImagePart((WordprocessingMLPackage)destDocument, (byte[])imageData);
        }
        catch (Exception e) {
            throw new DocxStamperException(e);
        }
    }

    public static Stream<P> streamParagraphs(WordprocessingMLPackage document) {
        return DocumentUtil.streamElements(document, P.class);
    }
}

