/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.util;

import jakarta.xml.bind.JAXBElement;
import java.util.ListIterator;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.P;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Tr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wickedsource.docxstamper.api.DocxStamperException;
import org.wickedsource.docxstamper.util.TableCellUtil;

public class ObjectDeleter {
    private static final Logger log = LoggerFactory.getLogger(ObjectDeleter.class);

    private ObjectDeleter() {
        throw new DocxStamperException("Utility class shouldn't be instantiated");
    }

    public static void deleteParagraph(P paragraph) {
        Object object = paragraph.getParent();
        if (object instanceof Tc) {
            Tc parentCell = (Tc)object;
            ObjectDeleter.deleteFromCell(parentCell, paragraph);
        } else {
            ((ContentAccessor)paragraph.getParent()).getContent().remove(paragraph);
        }
    }

    public static void deleteTable(Tbl table) {
        Object object = table.getParent();
        if (object instanceof Tc) {
            Tc parentCell = (Tc)object;
            ObjectDeleter.deleteFromCell(parentCell, table);
        } else {
            ((ContentAccessor)table.getParent()).getContent().remove(table.getParent());
            ListIterator iterator = ((ContentAccessor)table.getParent()).getContent().listIterator();
            while (iterator.hasNext()) {
                JAXBElement element;
                Object next = iterator.next();
                if (!(next instanceof JAXBElement) || !(element = (JAXBElement)next).getValue().equals(table)) continue;
                iterator.remove();
                break;
            }
        }
    }

    private static void deleteFromCell(Tc cell, P paragraph) {
        cell.getContent().remove(paragraph);
        if (TableCellUtil.hasNoParagraphOrTable(cell)) {
            TableCellUtil.addEmptyParagraph(cell);
        }
    }

    private static void deleteFromCell(Tc cell, Object obj) {
        if (!(obj instanceof Tbl) && !(obj instanceof P)) {
            throw new AssertionError((Object)"Only delete Tables or Paragraphs with this method.");
        }
        cell.getContent().remove(obj);
        if (TableCellUtil.hasNoParagraphOrTable(cell)) {
            TableCellUtil.addEmptyParagraph(cell);
        }
    }

    public static void deleteTableRow(Tr tableRow) {
        Object object = tableRow.getParent();
        if (object instanceof Tbl) {
            Tbl table = (Tbl)object;
            table.getContent().remove(tableRow);
        } else {
            log.error("Table row is not contained within a table. Unable to remove");
        }
    }
}

