/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.wickedsource.docxstamper.util.IndexedRun;
import org.wickedsource.docxstamper.util.RunUtil;

public class ParagraphWrapper {
    private final List<IndexedRun> runs = new ArrayList<IndexedRun>();
    private final P paragraph;
    private int currentPosition = 0;

    public ParagraphWrapper(P paragraph) {
        this.paragraph = paragraph;
        this.recalculateRuns();
    }

    public void recalculateRuns() {
        this.currentPosition = 0;
        this.runs.clear();
        int index = 0;
        for (Object contentElement : this.paragraph.getContent()) {
            R r;
            if (contentElement instanceof R && !RunUtil.getText(r = (R)contentElement).isEmpty()) {
                this.addRun(r, index);
            }
            ++index;
        }
    }

    private void addRun(R run, int index) {
        int startIndex = this.currentPosition;
        int endIndex = this.currentPosition + RunUtil.getText(run).length() - 1;
        this.runs.add(new IndexedRun(startIndex, endIndex, index, run));
        this.currentPosition = endIndex + 1;
    }

    public void replace(String placeholder, R replacement) {
        boolean singleRun;
        String text = this.getText();
        int matchStartIndex = text.indexOf(placeholder);
        if (matchStartIndex == -1) {
            return;
        }
        int matchEndIndex = matchStartIndex + placeholder.length() - 1;
        List<IndexedRun> affectedRuns = this.getAffectedRuns(matchStartIndex, matchEndIndex);
        boolean bl = singleRun = affectedRuns.size() == 1;
        if (singleRun) {
            IndexedRun run = affectedRuns.get(0);
            boolean placeholderSpansCompleteRun = placeholder.length() == RunUtil.getText(run.run()).length();
            boolean placeholderAtStartOfRun = matchStartIndex == run.startIndex();
            boolean placeholderAtEndOfRun = matchEndIndex == run.endIndex();
            boolean placeholderWithinRun = matchStartIndex > run.startIndex() && matchEndIndex < run.endIndex();
            replacement.setRPr(run.run().getRPr());
            if (placeholderSpansCompleteRun) {
                this.paragraph.getContent().remove(run.run());
                this.paragraph.getContent().add(run.indexInParent(), replacement);
                this.recalculateRuns();
            } else if (placeholderAtStartOfRun) {
                run.replace(matchStartIndex, matchEndIndex, "");
                this.paragraph.getContent().add(run.indexInParent(), replacement);
                this.recalculateRuns();
            } else if (placeholderAtEndOfRun) {
                run.replace(matchStartIndex, matchEndIndex, "");
                this.paragraph.getContent().add(run.indexInParent() + 1, replacement);
                this.recalculateRuns();
            } else if (placeholderWithinRun) {
                String runText = RunUtil.getText(run.run());
                int startIndex = runText.indexOf(placeholder);
                int endIndex = startIndex + placeholder.length();
                R run1 = RunUtil.create(runText.substring(0, startIndex), this.paragraph);
                R run2 = RunUtil.create(runText.substring(endIndex), this.paragraph);
                this.paragraph.getContent().add(run.indexInParent(), run2);
                this.paragraph.getContent().add(run.indexInParent(), replacement);
                this.paragraph.getContent().add(run.indexInParent(), run1);
                this.paragraph.getContent().remove(run.run());
                this.recalculateRuns();
            }
        } else {
            IndexedRun firstRun = affectedRuns.get(0);
            IndexedRun lastRun = affectedRuns.get(affectedRuns.size() - 1);
            replacement.setRPr(firstRun.run().getRPr());
            firstRun.replace(matchStartIndex, matchEndIndex, "");
            lastRun.replace(matchStartIndex, matchEndIndex, "");
            for (IndexedRun run : affectedRuns) {
                if (Objects.equals(run, firstRun) || Objects.equals(run, lastRun)) continue;
                this.paragraph.getContent().remove(run.run());
            }
            this.paragraph.getContent().add(firstRun.indexInParent() + 1, replacement);
            this.recalculateRuns();
        }
    }

    public String getText() {
        return this.runs.stream().map(IndexedRun::run).map(RunUtil::getText).collect(Collectors.joining());
    }

    private List<IndexedRun> getAffectedRuns(int startIndex, int endIndex) {
        return this.runs.stream().filter(run -> run.isTouchedByRange(startIndex, endIndex)).toList();
    }

    public List<R> getRuns() {
        return this.runs.stream().map(IndexedRun::run).toList();
    }

    public String toString() {
        return this.getText();
    }

    public P getParagraph() {
        return this.paragraph;
    }
}

