/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.util;

import java.util.List;
import java.util.Optional;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.SectPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wickedsource.docxstamper.api.DocxStamperException;

public class SectionUtil {
    private static final Logger log = LoggerFactory.getLogger(SectionUtil.class);
    private static final ObjectFactory factory = Context.getWmlObjectFactory();

    private SectionUtil() {
        throw new DocxStamperException("Utility class shouldn't be instantiated");
    }

    public static SectPr getPreviousSectionBreakIfPresent(Object firstObject, ContentAccessor parent) {
        List parentContent = parent.getContent();
        int pIndex = parentContent.indexOf(firstObject);
        for (int i = pIndex - 1; i >= 0; --i) {
            Object e = parentContent.get(i);
            if (!(e instanceof P)) continue;
            P prevParagraph = (P)e;
            PPr pPr = prevParagraph.getPPr();
            if (pPr != null && pPr.getSectPr() != null) {
                return pPr.getSectPr();
            }
            return null;
        }
        log.info("No previous section break found from : {}, first object index={}", (Object)parent, (Object)pIndex);
        return null;
    }

    public static SectPr getParagraphSectionBreak(P p) {
        return p.getPPr() != null && p.getPPr().getSectPr() != null ? p.getPPr().getSectPr() : null;
    }

    public static boolean isOddNumberOfSectionBreaks(List<Object> objects) {
        long count = objects.stream().filter(P.class::isInstance).map(P.class::cast).filter(p -> p.getPPr() != null && p.getPPr().getSectPr() != null).count();
        return count % 2L != 0L;
    }

    public static void applySectionBreakToParagraph(SectPr sectPr, P paragraph) {
        PPr nextPPr = Optional.ofNullable(paragraph.getPPr()).orElseGet(() -> ((ObjectFactory)factory).createPPr());
        nextPPr.setSectPr((SectPr)XmlUtils.deepCopy((Object)sectPr));
        paragraph.setPPr(nextPPr);
    }
}

