/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.util;

import jakarta.xml.bind.JAXBElement;
import java.util.function.Predicate;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.wickedsource.docxstamper.api.DocxStamperException;

public class TableCellUtil {
    private static final ObjectFactory objectFactory = new ObjectFactory();

    private TableCellUtil() {
        throw new DocxStamperException("Utility class shouldn't be instantiated");
    }

    public static boolean hasNoParagraphOrTable(Tc cell) {
        Predicate<Object> isP = P.class::isInstance;
        Predicate<Object> isTbl = e -> {
            JAXBElement jaxbElement;
            return e instanceof JAXBElement && (jaxbElement = (JAXBElement)e).getValue() instanceof Tbl;
        };
        return cell.getContent().stream().noneMatch(isP.or(isTbl));
    }

    public static void addEmptyParagraph(Tc cell) {
        P paragraph = objectFactory.createP();
        paragraph.getContent().add(objectFactory.createR());
        cell.getContent().add(paragraph);
    }
}

