/*
 * Decompiled with CFR 0.152.
 */
package pro.verron.docxstamper.utils;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import pro.verron.docxstamper.utils.ThrowingRunnable;

public class ProcessorExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final AtomicReference<Throwable> exception = new AtomicReference();
    private final List<Runnable> onException = new CopyOnWriteArrayList<Runnable>();

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.exception.set(e);
        this.onException.forEach(Runnable::run);
    }

    public void onException(ThrowingRunnable runnable) {
        this.onException.add(runnable);
    }

    public Optional<Throwable> exception() {
        return Optional.ofNullable(this.exception.get());
    }
}

