package org.wickedsource.docxstamper.api;

import pro.verron.officestamper.api.OfficeStamperException;

/**
 * This exception is thrown if an expression could not be processed by any comment processor.
 *
 * @author Joseph Verron
 * @author Tom Hombergs
 * @version 1.6.8
 * @since 1.0.3
 */
public class UnresolvedExpressionException
        extends OfficeStamperException {
    /**
     * <p>Constructor for UnresolvedExpressionException.</p>
     *
     * @param expression the expression that could not be processed.
     * @param cause      the root cause for this exception
     */
    public UnresolvedExpressionException(String expression, Throwable cause) {
        super(String.format("The following expression could not be processed by any comment processor: %s", expression),
                cause);
    }
}
