package pro.yinghuo.common.response;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;


/**
 * @author blade
 * @author blade
 * NoArgsConstructor 自动生成无参构造函数
 */
@Data
@ToString
@NoArgsConstructor
public class ResponseResult implements Response {

    /**
     * 操作是否成功
     */
    boolean success = SUCCESS;

    /**
     * 操作代码
     */
    int code = SUCCESS_CODE;

    /**
     * 提示信息
     */
    String message;

    public ResponseResult(ResultCode resultCode){
        this.success = resultCode.success();
        this.code = resultCode.code();
        this.message = resultCode.message();
    }

    public static ResponseResult success(){
        return new ResponseResult(CommonCode.SUCCESS);
    }
    public static ResponseResult fail(){
        return new ResponseResult(CommonCode.FAIL);
    }

}
