/*
 * Decompiled with CFR 0.152.
 */
package pro.yinghuo.common.response;

import cn.hutool.core.collection.CollectionUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.Lists;
import java.io.Serializable;
import pro.yinghuo.common.response.CommonCode;
import pro.yinghuo.common.response.QueryResult;
import pro.yinghuo.common.response.ResponseResult;
import pro.yinghuo.common.response.ResultCode;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class QueryResponseResult<T>
extends ResponseResult
implements Serializable {
    private QueryResult<T> queryResult;

    public QueryResponseResult(ResultCode resultCode) {
        super(resultCode);
    }

    public QueryResponseResult(ResultCode resultCode, QueryResult<T> queryResult) {
        super(resultCode);
        this.queryResult = queryResult;
    }

    public QueryResponseResult(ResultCode resultCode, T t) {
        super(resultCode);
        QueryResult queryResult = new QueryResult();
        queryResult.setList(Lists.newArrayList((Object[])new Object[]{t}));
        this.queryResult = queryResult;
    }

    @JsonIgnore
    public T getIndex0() {
        if (this.queryResult != null && CollectionUtil.isNotEmpty(this.queryResult.getList())) {
            return this.queryResult.getList().get(0);
        }
        return null;
    }

    @JsonIgnore
    public QueryResponseResult<T> getEmptyList() {
        this.success = CommonCode.SUCCESS.success();
        this.code = CommonCode.SUCCESS.code();
        this.message = CommonCode.SUCCESS.message();
        QueryResult queryResult = new QueryResult();
        queryResult.setList(Lists.newArrayList());
        this.queryResult = queryResult;
        return this;
    }

    @JsonIgnore
    public QueryResponseResult<T> getSingletonResponse(T t) {
        this.success = CommonCode.SUCCESS.success();
        this.code = CommonCode.SUCCESS.code();
        this.message = CommonCode.SUCCESS.message();
        QueryResult queryResult = new QueryResult();
        queryResult.setList(Lists.newArrayList((Object[])new Object[]{t}));
        this.queryResult = queryResult;
        return this;
    }

    public QueryResult<T> getQueryResult() {
        return this.queryResult;
    }

    public void setQueryResult(QueryResult<T> queryResult) {
        this.queryResult = queryResult;
    }

    @Override
    public String toString() {
        return "QueryResponseResult(queryResult=" + this.getQueryResult() + ")";
    }

    public QueryResponseResult() {
    }
}

