/*
 * Decompiled with CFR 0.152.
 */
package pro.yinghuo.common.utils;

import cn.hutool.core.collection.CollectionUtil;
import com.google.common.collect.Lists;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import pro.yinghuo.common.response.CommonCode;
import pro.yinghuo.common.response.QueryResponseResult;
import pro.yinghuo.common.response.QueryResult;
import pro.yinghuo.common.response.ResultCode;

public class StreamUtils {
    private static final Logger log = LoggerFactory.getLogger(StreamUtils.class);

    public static <T, V> List<V> getPojoToVo(List<T> list, Class<V> cls) {
        if (CollectionUtil.isEmpty(list)) {
            return new ArrayList();
        }
        return list.stream().map(t -> {
            Object v = null;
            try {
                v = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.error("\u521d\u59cb\u5316vo\u5bf9\u8c61\u51fa\u9519");
            }
            BeanUtils.copyProperties((Object)t, v);
            return v;
        }).collect(Collectors.toList());
    }

    public static <T, V> List<V> getModifyPojoToVo(List<T> list, Class<V> cls, Function<V, V> ... functions) {
        if (CollectionUtil.isEmpty(list)) {
            return new ArrayList();
        }
        return list.stream().map(t -> {
            Object v = null;
            try {
                v = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.error("\u521d\u59cb\u5316vo\u5bf9\u8c61\u51fa\u9519");
            }
            BeanUtils.copyProperties((Object)t, v);
            for (Function function : functions) {
                function.apply(v);
            }
            return v;
        }).collect(Collectors.toList());
    }

    public static <T, V> QueryResponseResult<V> getPojoToVoToResponse(List<T> list, Class<V> cls, long total) {
        List<V> listResult = StreamUtils.getPojoToVo(list, cls);
        QueryResult<V> result = new QueryResult<V>();
        result.setList(listResult);
        result.setTotal(total);
        return new QueryResponseResult((ResultCode)CommonCode.SUCCESS, result);
    }

    @SafeVarargs
    public static <T, V> QueryResponseResult<V> getModifyPojoToVoToResponse(List<T> list, Class<V> cls, long total, Function<V, V> ... functions) {
        List<V> listResult = StreamUtils.getModifyPojoToVo(list, cls, functions);
        QueryResult<V> result = new QueryResult<V>();
        result.setList(listResult);
        result.setTotal(total);
        return new QueryResponseResult((ResultCode)CommonCode.SUCCESS, result);
    }

    public static <T, V> QueryResponseResult<V> modifyConvert(List<T> list, Class<V> cls, long total, Function<T, V> function) {
        List<V> listResult = StreamUtils.modifyConvert(list, cls, function);
        QueryResult<V> result = new QueryResult<V>();
        result.setList(listResult);
        result.setTotal(total);
        return new QueryResponseResult((ResultCode)CommonCode.SUCCESS, result);
    }

    public static <T, V> List<V> modifyConvert(List<T> list, Class<V> cls, Function<T, V> function) {
        if (CollectionUtil.isEmpty(list)) {
            return new ArrayList();
        }
        return list.stream().map(t -> {
            Object v = null;
            try {
                v = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.error("\u521d\u59cb\u5316vo\u5bf9\u8c61\u51fa\u9519");
            }
            v = function.apply(t);
            return v;
        }).collect(Collectors.toList());
    }

    public static <T> QueryResponseResult<T> getSimpleResponse(List<T> list, long total) {
        QueryResult result = new QueryResult();
        if (CollectionUtil.isEmpty(list)) {
            list = Lists.newArrayList();
        }
        result.setList(list);
        result.setTotal(total);
        return new QueryResponseResult((ResultCode)CommonCode.SUCCESS, result);
    }

    public static <T, V> V simpleConvert(T obj, Class<V> cls) {
        V v = null;
        try {
            v = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error("\u521d\u59cb\u5316vo\u5bf9\u8c61\u51fa\u9519");
        }
        BeanUtils.copyProperties(obj, v);
        return v;
    }

    public static <T> QueryResponseResult<T> getSingleton(T t) {
        QueryResult result = new QueryResult();
        result.setList(Lists.newArrayList((Object[])new Object[]{t}));
        result.setTotal(1L);
        return new QueryResponseResult((ResultCode)CommonCode.SUCCESS, result);
    }

    public static <T> QueryResponseResult<T> getSingleton(T t, ResultCode resultCode) {
        QueryResult result = new QueryResult();
        result.setList(Lists.newArrayList((Object[])new Object[]{t}));
        result.setTotal(1L);
        return new QueryResponseResult(resultCode, result);
    }

    public static <T> QueryResponseResult<T> getEmpty() {
        QueryResult result = new QueryResult();
        result.setList(Lists.newArrayList());
        result.setTotal(0L);
        return new QueryResponseResult((ResultCode)CommonCode.SUCCESS, result);
    }

    public static <T, V> QueryResponseResult<V> getSingleton(T t, Class<V> cls) {
        Object v = null;
        try {
            v = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error("\u521d\u59cb\u5316vo\u5bf9\u8c61\u51fa\u9519");
        }
        if (t == null) {
            QueryResult result = new QueryResult();
            result.setList(Lists.newArrayList());
            result.setTotal(1L);
            return new QueryResponseResult((ResultCode)CommonCode.SUCCESS, result);
        }
        BeanUtils.copyProperties(t, v);
        QueryResult result = new QueryResult();
        result.setList(Lists.newArrayList((Object[])new Object[]{v}));
        result.setTotal(1L);
        return new QueryResponseResult((ResultCode)CommonCode.SUCCESS, result);
    }

    public static void oneConvertModify(Object source, String dateFormat, Object target) {
        if (dateFormat == null) {
            dateFormat = "yyyy-MM-dd HH:mm:ss";
        }
        Class<?> aClass = source.getClass();
        PropertyDescriptor[] apds = BeanUtils.getPropertyDescriptors(aClass);
        Class<?> bClass = target.getClass();
        for (PropertyDescriptor targetPd : BeanUtils.getPropertyDescriptors(bClass)) {
            PropertyDescriptor sourcePd;
            Method writeMethod = targetPd.getWriteMethod();
            if (writeMethod == null || (sourcePd = BeanUtils.getPropertyDescriptor(source.getClass(), (String)targetPd.getName())) == null) continue;
            Method readMethod = sourcePd.getReadMethod();
            for (int j = 0; j < apds.length; ++j) {
                PropertyDescriptor apd = apds[j];
                if (!apd.getReadMethod().getName().equals(readMethod.getName())) continue;
                readMethod = apd.getReadMethod();
                break;
            }
            if (readMethod == null) continue;
            if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                readMethod.setAccessible(true);
            }
            Object value = null;
            try {
                value = readMethod.invoke(source, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            if (value == null) continue;
            if (value.getClass().equals(Long.class)) {
                SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
                value = sdf.format(value);
            }
            if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                writeMethod.setAccessible(true);
            }
            try {
                writeMethod.invoke(target, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

