/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.body.MultipartBody;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import pro.zackpollard.telegrambot.api.TelegramBot;
import pro.zackpollard.telegrambot.api.chat.ChatMember;
import pro.zackpollard.telegrambot.api.chat.ChatType;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableTextMessage;
import pro.zackpollard.telegrambot.api.internal.chat.ChatMemberImpl;
import pro.zackpollard.telegrambot.api.user.User;
import pro.zackpollard.telegrambot.api.utils.Utils;

public interface Chat {
    public String getId();

    public String getName();

    public ChatType getType();

    public TelegramBot getBotInstance();

    public Message sendMessage(SendableMessage var1);

    default public Message sendMessage(String message) {
        return this.sendMessage(SendableTextMessage.builder().message(message).build());
    }

    default public Integer getChatMembersCount() {
        try {
            MultipartBody request = Unirest.post((String)(this.getBotInstance().getBotAPIUrl() + "getChatMembersCount")).field("chat_id", (Object)this.getId(), "application/json; charset=utf8;");
            HttpResponse response = request.asString();
            JSONObject jsonResponse = Utils.processResponse((HttpResponse<String>)response);
            if (jsonResponse != null && Utils.checkResponseStatus(jsonResponse)) {
                return jsonResponse.getInt("result");
            }
        }
        catch (UnirestException e) {
            e.printStackTrace();
        }
        return null;
    }

    default public List<ChatMember> getChatAdministrators() {
        try {
            MultipartBody request = Unirest.post((String)(this.getBotInstance().getBotAPIUrl() + "getChatAdministrators")).field("chat_id", (Object)this.getId(), "application/json; charset=utf8;");
            HttpResponse response = request.asString();
            JSONObject jsonResponse = Utils.processResponse((HttpResponse<String>)response);
            if (jsonResponse != null && Utils.checkResponseStatus(jsonResponse)) {
                JSONArray jsonArray = jsonResponse.getJSONArray("result");
                ArrayList<ChatMember> chatAdmins = new ArrayList<ChatMember>();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    chatAdmins.add(ChatMemberImpl.createChatMember(jsonObject));
                }
                return chatAdmins;
            }
        }
        catch (UnirestException e) {
            e.printStackTrace();
        }
        return null;
    }

    default public ChatMember getChatMember(User user) {
        return this.getChatMember(user.getId());
    }

    default public ChatMember getChatMember(long userID) {
        try {
            MultipartBody request = Unirest.post((String)(this.getBotInstance().getBotAPIUrl() + "getChatMember")).field("chat_id", (Object)this.getId(), "application/json; charset=utf8;").field("user_id", (Object)userID);
            HttpResponse response = request.asString();
            JSONObject jsonResponse = Utils.processResponse((HttpResponse<String>)response);
            if (jsonResponse != null && Utils.checkResponseStatus(jsonResponse)) {
                return ChatMemberImpl.createChatMember(jsonResponse.getJSONObject("result"));
            }
        }
        catch (UnirestException e) {
            e.printStackTrace();
        }
        return null;
    }

    default public boolean leaveChat() {
        try {
            MultipartBody request = Unirest.post((String)(this.getBotInstance().getBotAPIUrl() + "leaveChat")).field("chat_id", (Object)this.getId(), "application/json; charset=utf8;");
            HttpResponse response = request.asString();
            JSONObject jsonResponse = Utils.processResponse((HttpResponse<String>)response);
            if (jsonResponse != null && Utils.checkResponseStatus(jsonResponse)) {
                return jsonResponse.getBoolean("result");
            }
        }
        catch (UnirestException e) {
            e.printStackTrace();
        }
        return false;
    }
}

