/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.inline.send.results;

import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.inline.InlineReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.inline.send.content.InputMessageContent;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResultCached;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResultType;
import pro.zackpollard.telegrambot.api.utils.Utils;

public class InlineQueryResultCachedVideo
implements InlineQueryResultCached {
    private final InlineQueryResultType type = InlineQueryResultType.VIDEO;
    @NonNull
    private final String id;
    @NonNull
    private final String video_file_id;
    @NonNull
    private final String title;
    private final String caption;
    private final String description;
    private final InlineReplyMarkup reply_markup;
    private final InputMessageContent input_message_content;

    public static InlineQueryResultCachedVideoBuilder builder() {
        return new InlineQueryResultCachedVideoBuilder();
    }

    @Override
    public InlineQueryResultType getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public String getVideoFileId() {
        return this.video_file_id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getDescription() {
        return this.description;
    }

    public InlineReplyMarkup getReplyMarkup() {
        return this.reply_markup;
    }

    public InputMessageContent getInputMessageContent() {
        return this.input_message_content;
    }

    public String toString() {
        return "InlineQueryResultCachedVideo(type=" + (Object)((Object)this.getType()) + ", id=" + this.getId() + ", video_file_id=" + this.video_file_id + ", title=" + this.getTitle() + ", caption=" + this.getCaption() + ", description=" + this.getDescription() + ", reply_markup=" + this.reply_markup + ", input_message_content=" + this.input_message_content + ")";
    }

    private InlineQueryResultCachedVideo(@NonNull String id, @NonNull String video_file_id, @NonNull String title, String caption, String description, InlineReplyMarkup reply_markup, InputMessageContent input_message_content) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (video_file_id == null) {
            throw new NullPointerException("video_file_id");
        }
        if (title == null) {
            throw new NullPointerException("title");
        }
        this.id = id;
        this.video_file_id = video_file_id;
        this.title = title;
        this.caption = caption;
        this.description = description;
        this.reply_markup = reply_markup;
        this.input_message_content = input_message_content;
    }

    public static class InlineQueryResultCachedVideoBuilder {
        private String id = Utils.generateRandomString(32);
        private String video_file_id;
        private String title;
        private String caption;
        private String description;
        private InlineReplyMarkup reply_markup;
        private InputMessageContent input_message_content;

        InlineQueryResultCachedVideoBuilder() {
        }

        public InlineQueryResultCachedVideoBuilder id(String id) {
            this.id = id;
            return this;
        }

        public InlineQueryResultCachedVideoBuilder videoFileId(String videoFileId) {
            this.video_file_id = videoFileId;
            return this;
        }

        public InlineQueryResultCachedVideoBuilder title(String title) {
            this.title = title;
            return this;
        }

        public InlineQueryResultCachedVideoBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public InlineQueryResultCachedVideoBuilder description(String description) {
            this.description = description;
            return this;
        }

        public InlineQueryResultCachedVideoBuilder replyMarkup(InlineReplyMarkup replyMarkup) {
            this.reply_markup = replyMarkup;
            return this;
        }

        public InlineQueryResultCachedVideoBuilder inputMessageContent(InputMessageContent inputMessageContent) {
            this.input_message_content = inputMessageContent;
            return this;
        }

        public InlineQueryResultCachedVideo build() {
            return new InlineQueryResultCachedVideo(this.id, this.video_file_id, this.title, this.caption, this.description, this.reply_markup, this.input_message_content);
        }

        public String toString() {
            return "InlineQueryResultCachedVideo.InlineQueryResultCachedVideoBuilder(id=" + this.id + ", video_file_id=" + this.video_file_id + ", title=" + this.title + ", caption=" + this.caption + ", description=" + this.description + ", reply_markup=" + this.reply_markup + ", input_message_content=" + this.input_message_content + ")";
        }
    }
}

