/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.message.send;

import java.net.URL;
import lombok.NonNull;

public class CallbackQueryResponse {
    @NonNull
    private final String text;
    private final boolean show_alert;
    private final URL url;
    private final Integer cache_time;

    public static CallbackQueryResponseBuilder builder() {
        return new CallbackQueryResponseBuilder();
    }

    @NonNull
    public String getText() {
        return this.text;
    }

    public boolean isShowAlert() {
        return this.show_alert;
    }

    public URL getURL() {
        return this.url;
    }

    public Integer getCacheTime() {
        return this.cache_time;
    }

    public String toString() {
        return "CallbackQueryResponse(text=" + this.getText() + ", show_alert=" + this.show_alert + ", url=" + this.getURL() + ", cache_time=" + this.cache_time + ")";
    }

    private CallbackQueryResponse(@NonNull String text, boolean show_alert, URL url, Integer cache_time) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        this.text = text;
        this.show_alert = show_alert;
        this.url = url;
        this.cache_time = cache_time;
    }

    public static class CallbackQueryResponseBuilder {
        private String text;
        private boolean show_alert;
        private URL url;
        private Integer cache_time;

        CallbackQueryResponseBuilder() {
        }

        public CallbackQueryResponseBuilder text(String text) {
            this.text = text;
            return this;
        }

        public CallbackQueryResponseBuilder showAlert(boolean showAlert) {
            this.show_alert = showAlert;
            return this;
        }

        public CallbackQueryResponseBuilder url(URL url) {
            this.url = url;
            return this;
        }

        public CallbackQueryResponseBuilder cacheTime(Integer cacheTime) {
            this.cache_time = cacheTime;
            return this;
        }

        public CallbackQueryResponse build() {
            return new CallbackQueryResponse(this.text, this.show_alert, this.url, this.cache_time);
        }

        public String toString() {
            return "CallbackQueryResponse.CallbackQueryResponseBuilder(text=" + this.text + ", show_alert=" + this.show_alert + ", url=" + this.url + ", cache_time=" + this.cache_time + ")";
        }
    }
}

